/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.event.job;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractEvent
implements IOReadableWritable {
    private static final AtomicLong GLOBAL_SEQUENCE_NUMBER = new AtomicLong(0L);
    private static final SimpleDateFormat DATA_FORMATTER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private long timestamp = -1L;
    private long sequenceNumber = -1L;

    public AbstractEvent(long timestamp) {
        this.timestamp = timestamp;
        this.sequenceNumber = GLOBAL_SEQUENCE_NUMBER.incrementAndGet();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public AbstractEvent() {
    }

    public void read(DataInputView in) throws IOException {
        this.timestamp = in.readLong();
        this.sequenceNumber = in.readLong();
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.sequenceNumber);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static String timestampToString(long timestamp) {
        return DATA_FORMATTER.format(new Date(timestamp));
    }

    public boolean equals(Object obj) {
        AbstractEvent abstractEvent;
        return obj instanceof AbstractEvent && this.timestamp == (abstractEvent = (AbstractEvent)obj).getTimestamp();
    }

    public int hashCode() {
        return (int)(this.timestamp % Integer.MAX_VALUE);
    }
}

