/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.deployment;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.deployment.GateDeploymentDescriptor;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.nephele.util.SerializableArrayList;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class TaskDeploymentDescriptor
implements IOReadableWritable {
    private final JobID jobID;
    private final ExecutionVertexID vertexID;
    private String taskName;
    private int indexInSubtaskGroup;
    private int currentNumberOfSubtasks;
    private Configuration jobConfiguration;
    private Configuration taskConfiguration;
    private Class<? extends AbstractInvokable> invokableClass;
    private final SerializableArrayList<GateDeploymentDescriptor> outputGates;
    private final SerializableArrayList<GateDeploymentDescriptor> inputGates;

    public TaskDeploymentDescriptor(JobID jobID, ExecutionVertexID vertexID, String taskName, int indexInSubtaskGroup, int currentNumberOfSubtasks, Configuration jobConfiguration, Configuration taskConfiguration, Class<? extends AbstractInvokable> invokableClass, SerializableArrayList<GateDeploymentDescriptor> outputGates, SerializableArrayList<GateDeploymentDescriptor> inputGates) {
        if (jobID == null) {
            throw new IllegalArgumentException("Argument jobID must not be null");
        }
        if (vertexID == null) {
            throw new IllegalArgumentException("Argument vertexID must not be null");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Argument taskName must not be null");
        }
        if (indexInSubtaskGroup < 0) {
            throw new IllegalArgumentException("Argument indexInSubtaskGroup must not be smaller than zero");
        }
        if (currentNumberOfSubtasks < indexInSubtaskGroup) {
            throw new IllegalArgumentException("Argument currentNumberOfSubtasks must not be smaller than argument indexInSubtaskGroup");
        }
        if (jobConfiguration == null) {
            throw new IllegalArgumentException("Argument jobConfiguration must not be null");
        }
        if (taskConfiguration == null) {
            throw new IllegalArgumentException("Argument taskConfiguration must not be null");
        }
        if (invokableClass == null) {
            throw new IllegalArgumentException("Argument invokableClass must not be null");
        }
        if (outputGates == null) {
            throw new IllegalArgumentException("Argument outputGates must not be null");
        }
        if (inputGates == null) {
            throw new IllegalArgumentException("Argument inputGates must not be null");
        }
        this.jobID = jobID;
        this.vertexID = vertexID;
        this.taskName = taskName;
        this.indexInSubtaskGroup = indexInSubtaskGroup;
        this.currentNumberOfSubtasks = currentNumberOfSubtasks;
        this.jobConfiguration = jobConfiguration;
        this.taskConfiguration = taskConfiguration;
        this.invokableClass = invokableClass;
        this.outputGates = outputGates;
        this.inputGates = inputGates;
    }

    public TaskDeploymentDescriptor() {
        this.jobID = new JobID();
        this.vertexID = new ExecutionVertexID();
        this.taskName = null;
        this.indexInSubtaskGroup = 0;
        this.currentNumberOfSubtasks = 0;
        this.jobConfiguration = new Configuration();
        this.taskConfiguration = new Configuration();
        this.invokableClass = null;
        this.outputGates = new SerializableArrayList();
        this.inputGates = new SerializableArrayList();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        this.vertexID.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.taskName);
        out.writeInt(this.indexInSubtaskGroup);
        out.writeInt(this.currentNumberOfSubtasks);
        String[] requiredJarFiles = LibraryCacheManager.getRequiredJarFiles(this.jobID);
        out.writeInt(requiredJarFiles.length);
        for (int i = 0; i < requiredJarFiles.length; ++i) {
            StringRecord.writeString((DataOutput)out, (String)requiredJarFiles[i]);
        }
        if (this.invokableClass == null) {
            throw new IOException("this.invokableClass is null");
        }
        StringRecord.writeString((DataOutput)out, (String)this.invokableClass.getName());
        this.jobConfiguration.write(out);
        this.taskConfiguration.write(out);
        this.outputGates.write(out);
        this.inputGates.write(out);
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        this.vertexID.read(in);
        this.taskName = StringRecord.readString((DataInput)in);
        this.indexInSubtaskGroup = in.readInt();
        this.currentNumberOfSubtasks = in.readInt();
        String[] requiredJarFiles = new String[in.readInt()];
        for (int i = 0; i < requiredJarFiles.length; ++i) {
            requiredJarFiles[i] = StringRecord.readString((DataInput)in);
        }
        LibraryCacheManager.register(this.jobID, requiredJarFiles);
        ClassLoader cl = LibraryCacheManager.getClassLoader(this.jobID);
        String invokableClassName = StringRecord.readString((DataInput)in);
        if (invokableClassName == null) {
            throw new IOException("invokableClassName is null");
        }
        try {
            this.invokableClass = Class.forName(invokableClassName, true, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Class " + invokableClassName + " not found in one of the supplied jar files: " + StringUtils.stringifyException((Throwable)cnfe));
        }
        this.jobConfiguration = new Configuration(cl);
        this.jobConfiguration.read(in);
        this.taskConfiguration = new Configuration(cl);
        this.taskConfiguration.read(in);
        this.outputGates.read(in);
        this.inputGates.read(in);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public ExecutionVertexID getVertexID() {
        return this.vertexID;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getIndexInSubtaskGroup() {
        return this.indexInSubtaskGroup;
    }

    public int getCurrentNumberOfSubtasks() {
        return this.currentNumberOfSubtasks;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public Class<? extends AbstractInvokable> getInvokableClass() {
        return this.invokableClass;
    }

    public int getNumberOfOutputGateDescriptors() {
        return this.outputGates.size();
    }

    public GateDeploymentDescriptor getOutputGateDescriptor(int index) {
        return (GateDeploymentDescriptor)this.outputGates.get(index);
    }

    public int getNumberOfInputGateDescriptors() {
        return this.inputGates.size();
    }

    public GateDeploymentDescriptor getInputGateDescriptor(int index) {
        return (GateDeploymentDescriptor)this.inputGates.get(index);
    }
}

