/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.deployment;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.deployment.ChannelDeploymentDescriptor;
import eu.stratosphere.nephele.util.EnumUtils;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.runtime.io.gates.GateID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class GateDeploymentDescriptor
implements IOReadableWritable {
    private final GateID gateID;
    private ChannelType channelType;
    private final List<ChannelDeploymentDescriptor> channels;

    public GateDeploymentDescriptor(GateID gateID, ChannelType channelType, List<ChannelDeploymentDescriptor> channels) {
        if (gateID == null) {
            throw new IllegalArgumentException("Argument gateID must no be null");
        }
        if (channelType == null) {
            throw new IllegalArgumentException("Argument channelType must no be null");
        }
        if (channels == null) {
            throw new IllegalArgumentException("Argument channels must no be null");
        }
        this.gateID = gateID;
        this.channelType = channelType;
        this.channels = channels;
    }

    public GateDeploymentDescriptor() {
        this.gateID = new GateID();
        this.channelType = null;
        this.channels = new ArrayList<ChannelDeploymentDescriptor>();
    }

    public void write(DataOutputView out) throws IOException {
        this.gateID.write(out);
        EnumUtils.writeEnum((DataOutput)out, this.channelType);
        out.writeInt(this.channels.size());
        Iterator<ChannelDeploymentDescriptor> it = this.channels.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.gateID.read(in);
        this.channelType = EnumUtils.readEnum((DataInput)in, ChannelType.class);
        int nocdd = in.readInt();
        for (int i = 0; i < nocdd; ++i) {
            ChannelDeploymentDescriptor cdd = new ChannelDeploymentDescriptor();
            cdd.read(in);
            this.channels.add(cdd);
        }
    }

    public GateID getGateID() {
        return this.gateID;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public int getNumberOfChannelDescriptors() {
        return this.channels.size();
    }

    public ChannelDeploymentDescriptor getChannelDescriptor(int index) {
        return this.channels.get(index);
    }
}

