/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.client;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.util.EnumUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractJobResult
implements IOReadableWritable {
    private ReturnCode returnCode = ReturnCode.ERROR;
    private String description = null;

    public AbstractJobResult(ReturnCode returnCode, String description) {
        this.returnCode = returnCode;
        this.description = description;
    }

    public AbstractJobResult() {
    }

    public void read(DataInputView in) throws IOException {
        this.returnCode = EnumUtils.readEnum((DataInput)in, ReturnCode.class);
        this.description = StringRecord.readString((DataInput)in);
    }

    public void write(DataOutputView out) throws IOException {
        EnumUtils.writeEnum((DataOutput)out, this.returnCode);
        StringRecord.writeString((DataOutput)out, (String)this.description);
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractJobResult)) {
            return false;
        }
        AbstractJobResult ajr = (AbstractJobResult)obj;
        if (this.returnCode == null ? ajr.getReturnCode() != null : !this.returnCode.equals((Object)ajr.getReturnCode())) {
            return false;
        }
        return this.description == null || this.description.equals(ajr.getDescription());
    }

    public int hashCode() {
        long hashCode = 0L;
        if (this.returnCode != null) {
            hashCode += (long)this.returnCode.hashCode();
        }
        if (this.description != null) {
            hashCode += (long)this.description.hashCode();
        }
        return (int)(hashCode % Integer.MAX_VALUE);
    }

    public static enum ReturnCode {
        SUCCESS,
        ERROR;

    }
}

