/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.postpass;

import eu.stratosphere.compiler.postpass.AbstractSchema;
import eu.stratosphere.compiler.postpass.ConflictingFieldTypeInfoException;
import eu.stratosphere.types.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DenseValueSchema
extends AbstractSchema<Class<? extends Value>> {
    private final List<Class<? extends Value>> schema = new ArrayList<Class<? extends Value>>();
    private int numFields = -1;

    @Override
    public void addType(int pos, Class<? extends Value> type) throws ConflictingFieldTypeInfoException {
        if (pos == this.schema.size()) {
            this.schema.add(type);
        } else if (pos < this.schema.size()) {
            Class<? extends Value> previous = this.schema.get(pos);
            if (previous == null) {
                this.schema.set(pos, type);
            } else if (previous != type) {
                throw new ConflictingFieldTypeInfoException(pos, previous, type);
            }
        } else {
            for (int i = this.schema.size(); i <= pos; ++i) {
                this.schema.add(null);
            }
            this.schema.set(pos, type);
        }
    }

    @Override
    public Class<? extends Value> getType(int field) {
        return this.schema.get(field);
    }

    @Override
    public Iterator<Map.Entry<Integer, Class<? extends Value>>> iterator() {
        final Iterator<Class<? extends Value>> iter = this.schema.iterator();
        return new Iterator<Map.Entry<Integer, Class<? extends Value>>>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<Integer, Class<? extends Value>> next() {
                return new Entry(this.pos++, (Class)iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int numFields) {
        this.numFields = numFields;
    }

    public int hashCode() {
        return this.schema.hashCode() ^ this.getNumConnectionsThatContributed();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DenseValueSchema) {
            DenseValueSchema other = (DenseValueSchema)obj;
            return this.schema.equals(other.schema) && this.getNumConnectionsThatContributed() == other.getNumConnectionsThatContributed();
        }
        return false;
    }

    public String toString() {
        return "<" + this.getNumConnectionsThatContributed() + "> : " + this.schema.toString();
    }

    private static final class Entry
    implements Map.Entry<Integer, Class<? extends Value>> {
        private Integer key;
        private Class<? extends Value> value;

        public Entry(Integer key, Class<? extends Value> value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public Class<? extends Value> getValue() {
            return this.value;
        }

        @Override
        public Class<? extends Value> setValue(Class<? extends Value> value) {
            throw new UnsupportedOperationException();
        }
    }
}

