/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plandump;

import eu.stratosphere.api.common.operators.CompilerHints;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.dag.BinaryUnionNode;
import eu.stratosphere.compiler.dag.BulkIterationNode;
import eu.stratosphere.compiler.dag.DataSinkNode;
import eu.stratosphere.compiler.dag.DataSourceNode;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.TempMode;
import eu.stratosphere.compiler.dag.WorksetIterationNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.BulkIterationPlanNode;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.NAryUnionPlanNode;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.compiler.plan.WorksetIterationPlanNode;
import eu.stratosphere.compiler.plandump.DumpableConnection;
import eu.stratosphere.compiler.plandump.DumpableNode;
import eu.stratosphere.compiler.util.Utils;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.Visitable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PlanJSONDumpGenerator {
    private Map<DumpableNode<?>, Integer> nodeIds;
    private int nodeCnt;
    private static final char[] SIZE_SUFFIXES = new char[]{'\u0000', 'K', 'M', 'G', 'T'};

    public void dumpPactPlanAsJSON(List<DataSinkNode> nodes, PrintWriter writer) {
        List<DumpableNode<?>> n = nodes;
        this.compilePlanToJSON(n, writer);
    }

    public String getPactPlanAsJSON(List<DataSinkNode> nodes) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dumpPactPlanAsJSON(nodes, pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpOptimizerPlanAsJSON(OptimizedPlan plan, File toFile) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(toFile), false);
            this.dumpOptimizerPlanAsJSON(plan, pw);
            pw.flush();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public String getOptimizerPlanAsJSON(OptimizedPlan plan) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.dumpOptimizerPlanAsJSON(plan, pw);
        pw.close();
        return sw.toString();
    }

    public void dumpOptimizerPlanAsJSON(OptimizedPlan plan, PrintWriter writer) {
        Collection<SinkPlanNode> sinks = plan.getDataSinks();
        if (sinks instanceof List) {
            this.dumpOptimizerPlanAsJSON((List)sinks, writer);
        } else {
            ArrayList<SinkPlanNode> n = new ArrayList<SinkPlanNode>();
            n.addAll(sinks);
            this.dumpOptimizerPlanAsJSON(n, writer);
        }
    }

    public void dumpOptimizerPlanAsJSON(List<SinkPlanNode> nodes, PrintWriter writer) {
        List<DumpableNode<?>> n = nodes;
        this.compilePlanToJSON(n, writer);
    }

    private void compilePlanToJSON(List<DumpableNode<?>> nodes, PrintWriter writer) {
        this.nodeIds = new HashMap();
        this.nodeCnt = 0;
        writer.print("{\n\t\"nodes\": [\n\n");
        for (int i = 0; i < nodes.size(); ++i) {
            this.visit(nodes.get(i), writer, i == 0);
        }
        writer.println("\n\t]\n}");
    }

    private boolean visit(DumpableNode<?> node, PrintWriter writer, boolean first) {
        PlanNode p;
        String contents;
        String type;
        if (this.nodeIds.containsKey(node)) {
            return false;
        }
        this.nodeIds.put(node, this.nodeCnt++);
        for (DumpableNode child : node.getPredecessors()) {
            if (!this.visit(child, writer, first)) continue;
            first = false;
        }
        OptimizerNode n = node.getOptimizerNode();
        if (!first) {
            writer.print(",\n");
        }
        writer.print("\t{\n");
        if (node instanceof BulkIterationNode || node instanceof BulkIterationPlanNode) {
            DumpableNode<OptimizerNode> innerChild = node instanceof BulkIterationNode ? ((BulkIterationNode)node).getNextPartialSolution() : ((BulkIterationPlanNode)node).getRootOfStepFunction();
            Visitable<OptimizerNode> begin = node instanceof BulkIterationNode ? ((BulkIterationNode)node).getPartialSolution() : ((BulkIterationPlanNode)node).getPartialSolutionPlanNode();
            writer.print("\t\t\"step_function\": [\n");
            this.visit(innerChild, writer, true);
            writer.print("\n\t\t],\n");
            writer.print("\t\t\"partial_solution\": " + this.nodeIds.get(begin) + ",\n");
            writer.print("\t\t\"next_partial_solution\": " + this.nodeIds.get(innerChild) + ",\n");
        } else if (node instanceof WorksetIterationNode || node instanceof WorksetIterationPlanNode) {
            DumpableNode<OptimizerNode> worksetRoot = node instanceof WorksetIterationNode ? ((WorksetIterationNode)node).getNextWorkset() : ((WorksetIterationPlanNode)node).getNextWorkSetPlanNode();
            DumpableNode<OptimizerNode> solutionDelta = node instanceof WorksetIterationNode ? ((WorksetIterationNode)node).getSolutionSetDelta() : ((WorksetIterationPlanNode)node).getSolutionSetDeltaPlanNode();
            Visitable<OptimizerNode> workset = node instanceof WorksetIterationNode ? ((WorksetIterationNode)node).getWorksetNode() : ((WorksetIterationPlanNode)node).getWorksetPlanNode();
            Visitable<OptimizerNode> solutionSet = node instanceof WorksetIterationNode ? ((WorksetIterationNode)node).getSolutionSetNode() : ((WorksetIterationPlanNode)node).getSolutionSetPlanNode();
            writer.print("\t\t\"step_function\": [\n");
            this.visit(worksetRoot, writer, true);
            this.visit(solutionDelta, writer, false);
            writer.print("\n\t\t],\n");
            writer.print("\t\t\"workset\": " + this.nodeIds.get(workset) + ",\n");
            writer.print("\t\t\"solution_set\": " + this.nodeIds.get(solutionSet) + ",\n");
            writer.print("\t\t\"next_workset\": " + this.nodeIds.get(worksetRoot) + ",\n");
            writer.print("\t\t\"solution_delta\": " + this.nodeIds.get(solutionDelta) + ",\n");
        }
        writer.print("\t\t\"id\": " + this.nodeIds.get(node));
        if (n instanceof DataSinkNode) {
            type = "sink";
            contents = n.getPactContract().toString();
        } else if (n instanceof DataSourceNode) {
            type = "source";
            contents = n.getPactContract().toString();
        } else if (n instanceof BulkIterationNode) {
            type = "bulk_iteration";
            contents = n.getPactContract().getName();
        } else if (n instanceof WorksetIterationNode) {
            type = "workset_iteration";
            contents = n.getPactContract().getName();
        } else if (n instanceof BinaryUnionNode) {
            type = "pact";
            contents = "";
        } else {
            type = "pact";
            contents = n.getPactContract().getName();
        }
        String name = n.getName();
        if (name.equals("Reduce") && node instanceof SingleInputPlanNode && ((SingleInputPlanNode)node).getDriverStrategy() == DriverStrategy.SORTED_GROUP_COMBINE) {
            name = "Combine";
        }
        writer.print(",\n\t\t\"type\": \"" + type + "\"");
        writer.print(",\n\t\t\"pact\": \"" + name + "\"");
        writer.print(",\n\t\t\"contents\": \"" + contents + "\"");
        writer.print(",\n\t\t\"parallelism\": \"" + (n.getDegreeOfParallelism() >= 1 ? Integer.valueOf(n.getDegreeOfParallelism()) : "default") + "\"");
        Iterator<DumpableConnection<?>> inConns = node.getDumpableInputs().iterator();
        String child1name = "";
        String child2name = "";
        if (inConns != null && inConns.hasNext()) {
            writer.print(",\n\t\t\"predecessors\": [");
            int connNum = 0;
            int inputNum = 0;
            while (inConns.hasNext()) {
                Collection<DumpableConnection<Object>> inConnsForInput;
                DumpableConnection<?> conn = inConns.next();
                if (conn.getSource() instanceof NAryUnionPlanNode) {
                    inConnsForInput = new ArrayList();
                    for (DumpableConnection<Object> dumpableConnection : conn.getSource().getDumpableInputs()) {
                        inConnsForInput.add(dumpableConnection);
                    }
                } else {
                    inConnsForInput = Collections.singleton(conn);
                }
                for (DumpableConnection<Object> dumpableConnection : inConnsForInput) {
                    DumpableNode<Object> source = dumpableConnection.getSource();
                    writer.print(connNum == 0 ? "\n" : ",\n");
                    if (connNum == 0) {
                        child1name = child1name + (child1name.length() > 0 ? ", " : "");
                        child1name = child1name + source.getOptimizerNode().getPactContract().getName();
                    } else if (connNum == 1) {
                        child2name = child2name + (child2name.length() > 0 ? ", " : "");
                        child2name = source.getOptimizerNode().getPactContract().getName();
                    }
                    writer.print("\t\t\t{\"id\": " + this.nodeIds.get(source));
                    if (inConns.hasNext() || inputNum > 0) {
                        writer.print(", \"side\": \"" + (inputNum == 0 ? "first" : "second") + "\"");
                    }
                    Channel channel = dumpableConnection instanceof Channel ? (Channel)dumpableConnection : null;
                    ShipStrategyType shipType = channel != null ? channel.getShipStrategy() : ((PactConnection)dumpableConnection).getShipStrategy();
                    String shipStrategy = null;
                    if (shipType != null) {
                        switch (shipType) {
                            case NONE: {
                                break;
                            }
                            case FORWARD: {
                                shipStrategy = "Forward";
                                break;
                            }
                            case BROADCAST: {
                                shipStrategy = "Broadcast";
                                break;
                            }
                            case PARTITION_HASH: {
                                shipStrategy = "Hash Partition";
                                break;
                            }
                            case PARTITION_RANGE: {
                                shipStrategy = "Range Partition";
                                break;
                            }
                            case PARTITION_RANDOM: {
                                shipStrategy = "Redistribute";
                                break;
                            }
                            default: {
                                throw new CompilerException("Unknown ship strategy '" + conn.getShipStrategy().name() + "' in JSON generator.");
                            }
                        }
                    }
                    if (channel != null && channel.getShipStrategyKeys() != null && channel.getShipStrategyKeys().size() > 0) {
                        shipStrategy = shipStrategy + " on " + (channel.getShipStrategySortOrder() == null ? channel.getShipStrategyKeys().toString() : Utils.createOrdering(channel.getShipStrategyKeys(), channel.getShipStrategySortOrder()).toString());
                    }
                    if (shipStrategy != null) {
                        writer.print(", \"ship_strategy\": \"" + shipStrategy + "\"");
                    }
                    if (channel != null) {
                        String localStrategy = null;
                        switch (channel.getLocalStrategy()) {
                            case NONE: {
                                break;
                            }
                            case SORT: {
                                localStrategy = "Sort";
                                break;
                            }
                            case COMBININGSORT: {
                                localStrategy = "Sort (combining)";
                                break;
                            }
                            default: {
                                throw new CompilerException("Unknown local strategy " + channel.getLocalStrategy().name());
                            }
                        }
                        if (channel != null && channel.getLocalStrategyKeys() != null && channel.getLocalStrategyKeys().size() > 0) {
                            localStrategy = localStrategy + " on " + (channel.getLocalStrategySortOrder() == null ? channel.getLocalStrategyKeys().toString() : Utils.createOrdering(channel.getLocalStrategyKeys(), channel.getLocalStrategySortOrder()).toString());
                        }
                        if (localStrategy != null) {
                            writer.print(", \"local_strategy\": \"" + localStrategy + "\"");
                        }
                        if (channel != null && channel.getTempMode() != TempMode.NONE) {
                            String tempMode = channel.getTempMode().toString();
                            writer.print(", \"temp_mode\": \"" + tempMode + "\"");
                        }
                    }
                    writer.print('}');
                    ++connNum;
                }
                ++inputNum;
            }
            writer.print("\n\t\t]");
        }
        if ((p = node.getPlanNode()) == null) {
            writer.print("\n\t}");
            return true;
        }
        String locString = null;
        if (p.getDriverStrategy() != null) {
            switch (p.getDriverStrategy()) {
                case NONE: 
                case BINARY_NO_OP: {
                    break;
                }
                case UNARY_NO_OP: {
                    locString = "No-Op";
                    break;
                }
                case COLLECTOR_MAP: 
                case MAP: 
                case FLAT_MAP: {
                    locString = "Map";
                    break;
                }
                case ALL_REDUCE: {
                    locString = "Reduce All";
                    break;
                }
                case ALL_GROUP_REDUCE: 
                case ALL_GROUP_COMBINE: {
                    locString = "Group Reduce All";
                    break;
                }
                case SORTED_REDUCE: {
                    locString = "Sorted Reduce";
                    break;
                }
                case SORTED_PARTIAL_REDUCE: {
                    locString = "Sorted Combine/Reduce";
                    break;
                }
                case SORTED_GROUP_REDUCE: {
                    locString = "Sorted Group Reduce";
                    break;
                }
                case SORTED_GROUP_COMBINE: {
                    locString = "Sorted Combine";
                    break;
                }
                case HYBRIDHASH_BUILD_FIRST: {
                    locString = "Hybrid Hash (build: " + child1name + ")";
                    break;
                }
                case HYBRIDHASH_BUILD_SECOND: {
                    locString = "Hybrid Hash (build: " + child2name + ")";
                    break;
                }
                case HYBRIDHASH_BUILD_FIRST_CACHED: {
                    locString = "Hybrid Hash (CACHED) (build: " + child1name + ")";
                    break;
                }
                case HYBRIDHASH_BUILD_SECOND_CACHED: {
                    locString = "Hybrid Hash (CACHED) (build: " + child2name + ")";
                    break;
                }
                case NESTEDLOOP_BLOCKED_OUTER_FIRST: {
                    locString = "Nested Loops (Blocked Outer: " + child1name + ")";
                    break;
                }
                case NESTEDLOOP_BLOCKED_OUTER_SECOND: {
                    locString = "Nested Loops (Blocked Outer: " + child2name + ")";
                    break;
                }
                case NESTEDLOOP_STREAMED_OUTER_FIRST: {
                    locString = "Nested Loops (Streamed Outer: " + child1name + ")";
                    break;
                }
                case NESTEDLOOP_STREAMED_OUTER_SECOND: {
                    locString = "Nested Loops (Streamed Outer: " + child2name + ")";
                    break;
                }
                case MERGE: {
                    locString = "Merge";
                    break;
                }
                case CO_GROUP: {
                    locString = "Co-Group";
                    break;
                }
                default: {
                    throw new CompilerException("Unknown local strategy '" + p.getDriverStrategy().name() + "' in JSON generator.");
                }
            }
            if (locString != null) {
                writer.print(",\n\t\t\"driver_strategy\": \"");
                writer.print(locString);
                writer.print("\"");
            }
        }
        GlobalProperties gp = p.getGlobalProperties();
        writer.print(",\n\t\t\"global_properties\": [\n");
        this.addProperty(writer, "Partitioning", gp.getPartitioning().name(), true);
        if (gp.getPartitioningFields() != null) {
            this.addProperty(writer, "Partitioned on", gp.getPartitioningFields().toString(), false);
        }
        if (gp.getPartitioningOrdering() != null) {
            this.addProperty(writer, "Partitioning Order", gp.getPartitioningOrdering().toString(), false);
        } else {
            this.addProperty(writer, "Partitioning Order", "(none)", false);
        }
        if (n.getUniqueFields() == null || n.getUniqueFields().size() == 0) {
            this.addProperty(writer, "Uniqueness", "not unique", false);
        } else {
            this.addProperty(writer, "Uniqueness", n.getUniqueFields().toString(), false);
        }
        writer.print("\n\t\t]");
        LocalProperties lp = p.getLocalProperties();
        writer.print(",\n\t\t\"local_properties\": [\n");
        if (lp.getOrdering() != null) {
            this.addProperty(writer, "Order", lp.getOrdering().toString(), true);
        } else {
            this.addProperty(writer, "Order", "(none)", true);
        }
        if (lp.getGroupedFields() != null && lp.getGroupedFields().size() > 0) {
            this.addProperty(writer, "Grouped on", lp.getGroupedFields().toString(), false);
        } else {
            this.addProperty(writer, "Grouping", "not grouped", false);
        }
        if (n.getUniqueFields() == null || n.getUniqueFields().size() == 0) {
            this.addProperty(writer, "Uniqueness", "not unique", false);
        } else {
            this.addProperty(writer, "Uniqueness", n.getUniqueFields().toString(), false);
        }
        writer.print("\n\t\t]");
        writer.print(",\n\t\t\"estimates\": [\n");
        this.addProperty(writer, "Est. Output Size", n.getEstimatedOutputSize() == -1L ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(n.getEstimatedOutputSize(), "B"), true);
        this.addProperty(writer, "Est. Cardinality", n.getEstimatedNumRecords() == -1L ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(n.getEstimatedNumRecords()), false);
        writer.print("\t\t]");
        if (p.getNodeCosts() != null) {
            writer.print(",\n\t\t\"costs\": [\n");
            this.addProperty(writer, "Network", p.getNodeCosts().getNetworkCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getNodeCosts().getNetworkCost(), "B"), true);
            this.addProperty(writer, "Disk I/O", p.getNodeCosts().getDiskCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getNodeCosts().getDiskCost(), "B"), false);
            this.addProperty(writer, "CPU", p.getNodeCosts().getCpuCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getNodeCosts().getCpuCost(), ""), false);
            this.addProperty(writer, "Cumulative Network", p.getCumulativeCosts().getNetworkCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getCumulativeCosts().getNetworkCost(), "B"), false);
            this.addProperty(writer, "Cumulative Disk I/O", p.getCumulativeCosts().getDiskCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getCumulativeCosts().getDiskCost(), "B"), false);
            this.addProperty(writer, "Cumulative CPU", p.getCumulativeCosts().getCpuCost() == -1.0 ? "(unknown)" : PlanJSONDumpGenerator.formatNumber(p.getCumulativeCosts().getCpuCost(), ""), false);
            writer.print("\n\t\t]");
        }
        if (n.getPactContract().getCompilerHints() != null) {
            CompilerHints hints = n.getPactContract().getCompilerHints();
            CompilerHints defaults = new CompilerHints();
            String size = hints.getOutputSize() == defaults.getOutputSize() ? "(none)" : String.valueOf(hints.getOutputSize());
            String string = hints.getOutputCardinality() == defaults.getOutputCardinality() ? "(none)" : String.valueOf(hints.getOutputCardinality());
            String width = hints.getAvgOutputRecordSize() == defaults.getAvgOutputRecordSize() ? "(none)" : String.valueOf(hints.getAvgOutputRecordSize());
            String filter = hints.getFilterFactor() == defaults.getFilterFactor() ? "(none)" : String.valueOf(hints.getFilterFactor());
            writer.print(",\n\t\t\"compiler_hints\": [\n");
            this.addProperty(writer, "Output Size (bytes)", size, true);
            this.addProperty(writer, "Output Cardinality", string, false);
            this.addProperty(writer, "Avg. Output Record Size (bytes)", width, false);
            this.addProperty(writer, "Filter Factor", filter, false);
            writer.print("\t\t]");
        }
        writer.print("\n\t}");
        return true;
    }

    private void addProperty(PrintWriter writer, String name, String value, boolean first) {
        if (!first) {
            writer.print(",\n");
        }
        writer.print("\t\t\t{ \"name\": \"");
        writer.print(name);
        writer.print("\", \"value\": \"");
        writer.print(value);
        writer.print("\" }");
    }

    public static final String formatNumber(double number) {
        return PlanJSONDumpGenerator.formatNumber(number, "");
    }

    public static final String formatNumber(double number, String suffix) {
        if (number <= 0.0) {
            return String.valueOf(number);
        }
        int power = (int)Math.ceil(Math.log10(number));
        int group = (power - 1) / 3;
        if (group >= SIZE_SUFFIXES.length) {
            group = SIZE_SUFFIXES.length - 1;
        } else if (group < 0) {
            group = 0;
        }
        int beforeDecimal = power - group * 3;
        if (power > beforeDecimal) {
            for (int i = power - beforeDecimal; i > 0; --i) {
                number /= 10.0;
            }
        }
        return group > 0 ? String.format(Locale.US, "%.2f %s", number, Character.valueOf(SIZE_SUFFIXES[group])) : String.format(Locale.US, "%.2f", number);
    }
}

