/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.compiler.costs.Costs;
import eu.stratosphere.compiler.dag.WorksetNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.WorksetIterationPlanNode;
import eu.stratosphere.pact.runtime.task.DamBehavior;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.Collections;
import java.util.HashMap;

public class WorksetPlanNode
extends PlanNode {
    private static final Costs NO_COSTS = new Costs();
    private WorksetIterationPlanNode containingIterationNode;
    private final Channel initialInput;
    public Object postPassHelper;

    public WorksetPlanNode(WorksetNode template, String nodeName, GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        super(template, nodeName, DriverStrategy.NONE);
        this.globalProps = gProps;
        this.localProps = lProps;
        this.initialInput = initialInput;
        this.nodeCosts = NO_COSTS;
        this.cumulativeCosts = NO_COSTS;
        if (initialInput.getSource().branchPlan != null && initialInput.getSource().branchPlan.size() > 0) {
            if (this.branchPlan == null) {
                this.branchPlan = new HashMap();
            }
            this.branchPlan.putAll(initialInput.getSource().branchPlan);
        }
    }

    public WorksetNode getWorksetNode() {
        return (WorksetNode)this.template;
    }

    public WorksetIterationPlanNode getContainingIterationNode() {
        return this.containingIterationNode;
    }

    public void setContainingIterationNode(WorksetIterationPlanNode containingIterationNode) {
        this.containingIterationNode = containingIterationNode;
    }

    public void accept(Visitor<PlanNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            visitor.postVisit((Visitable)this);
        }
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport res = this.initialInput.getSource().hasDamOnPathDownTo(source);
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return this.initialInput.getLocalStrategy().dams() || this.initialInput.getTempMode().breaksPipeline() || this.getDriverStrategy().firstDam() == DamBehavior.FULL_DAM ? PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM : PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        return PlanNode.SourceAndDamReport.NOT_FOUND;
    }
}

