/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.costs.Costs;
import eu.stratosphere.compiler.dag.SinkJoiner;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import java.util.List;

public class SinkJoinerPlanNode
extends DualInputPlanNode {
    public SinkJoinerPlanNode(SinkJoiner template, Channel input1, Channel input2) {
        super(template, "", input1, input2, DriverStrategy.BINARY_NO_OP);
    }

    @Override
    public void setCosts(Costs nodeCosts) {
        Costs totalCosts = this.getInput1().getSource().getCumulativeCosts().clone();
        totalCosts.addCosts(this.getInput2().getSource().getCumulativeCosts());
        super.setCosts(totalCosts);
    }

    public void getDataSinks(List<SinkPlanNode> sinks) {
        PlanNode in1 = this.input1.getSource();
        PlanNode in2 = this.input2.getSource();
        if (in1 instanceof SinkPlanNode) {
            sinks.add((SinkPlanNode)in1);
        } else if (in1 instanceof SinkJoinerPlanNode) {
            ((SinkJoinerPlanNode)in1).getDataSinks(sinks);
        } else {
            throw new CompilerException("Illegal child node for a sink joiner utility node: Neither Sink nor Sink Joiner");
        }
        if (in2 instanceof SinkPlanNode) {
            sinks.add((SinkPlanNode)in2);
        } else if (in2 instanceof SinkJoinerPlanNode) {
            ((SinkJoinerPlanNode)in2).getDataSinks(sinks);
        } else {
            throw new CompilerException("Illegal child node for a sink joiner utility node: Neither Sink nor Sink Joiner");
        }
    }
}

