/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.typeutils.TypeComparatorFactory;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.SingleInputNode;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.NamedChannel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DamBehavior;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.ArrayList;
import java.util.Collections;

public class SingleInputPlanNode
extends PlanNode {
    protected final Channel input;
    protected final FieldList keys;
    protected final boolean[] sortOrders;
    private TypeComparatorFactory<?> comparator;
    public Object postPassHelper;

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy) {
        this(template, nodeName, input, driverStrategy, null, null);
    }

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy, FieldList driverKeyFields) {
        this(template, nodeName, input, driverStrategy, driverKeyFields, SingleInputPlanNode.getTrueArray(driverKeyFields.size()));
    }

    public SingleInputPlanNode(OptimizerNode template, String nodeName, Channel input, DriverStrategy driverStrategy, FieldList driverKeyFields, boolean[] driverSortOrders) {
        super(template, nodeName, driverStrategy);
        this.input = input;
        this.keys = driverKeyFields;
        this.sortOrders = driverSortOrders;
        if (this.input.getShipStrategy() == ShipStrategyType.BROADCAST) {
            this.input.setReplicationFactor(this.getDegreeOfParallelism());
        }
        PlanNode predNode = input.getSource();
        if (this.branchPlan == null) {
            this.branchPlan = predNode.branchPlan;
        } else if (predNode.branchPlan != null) {
            this.branchPlan.putAll(predNode.branchPlan);
        }
    }

    public SingleInputNode getSingleInputNode() {
        if (this.template instanceof SingleInputNode) {
            return (SingleInputNode)this.template;
        }
        throw new RuntimeException();
    }

    public Channel getInput() {
        return this.input;
    }

    public PlanNode getPredecessor() {
        return this.input.getSource();
    }

    public FieldList getKeys() {
        return this.keys;
    }

    public boolean[] getSortOrders() {
        return this.sortOrders;
    }

    public TypeComparatorFactory<?> getComparator() {
        return this.comparator;
    }

    public void setComparator(TypeComparatorFactory<?> comparator) {
        this.comparator = comparator;
    }

    public void accept(Visitor<PlanNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            this.input.getSource().accept(visitor);
            for (Channel channel : this.getBroadcastInputs()) {
                channel.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        if (this.getBroadcastInputs() == null || this.getBroadcastInputs().isEmpty()) {
            return Collections.singleton(this.input.getSource());
        }
        ArrayList<PlanNode> preds = new ArrayList<PlanNode>();
        preds.add(this.input.getSource());
        for (Channel channel : this.getBroadcastInputs()) {
            preds.add(channel.getSource());
        }
        return preds;
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.singleton(this.input);
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport res = this.input.getSource().hasDamOnPathDownTo(source);
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return this.input.getLocalStrategy().dams() || this.input.getTempMode().breaksPipeline() || this.getDriverStrategy().firstDam() == DamBehavior.FULL_DAM ? PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM : PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        for (NamedChannel nc : this.getBroadcastInputs()) {
            PlanNode.SourceAndDamReport bcRes = nc.getSource().hasDamOnPathDownTo(source);
            if (bcRes == PlanNode.SourceAndDamReport.NOT_FOUND) continue;
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        return PlanNode.SourceAndDamReport.NOT_FOUND;
    }

    protected static boolean[] getTrueArray(int length) {
        boolean[] a = new boolean[length];
        for (int i = 0; i < length; ++i) {
            a[i] = true;
        }
        return a;
    }
}

