/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.compiler.plan.SourcePlanNode;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.Collection;

public class OptimizedPlan
implements Visitable<PlanNode> {
    private final Collection<SourcePlanNode> dataSources;
    private final Collection<SinkPlanNode> dataSinks;
    private final Collection<PlanNode> allNodes;
    private final Plan pactPlan;
    private final String jobName;
    private String instanceTypeName;

    public OptimizedPlan(Collection<SourcePlanNode> sources, Collection<SinkPlanNode> sinks, Collection<PlanNode> allNodes, String jobName, Plan pactPlan) {
        this.dataSources = sources;
        this.dataSinks = sinks;
        this.allNodes = allNodes;
        this.jobName = jobName;
        this.pactPlan = pactPlan;
    }

    public Collection<SourcePlanNode> getDataSources() {
        return this.dataSources;
    }

    public Collection<SinkPlanNode> getDataSinks() {
        return this.dataSinks;
    }

    public Collection<PlanNode> getAllNodes() {
        return this.allNodes;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Plan getOriginalPactPlan() {
        return this.pactPlan;
    }

    public String getInstanceTypeName() {
        return this.instanceTypeName;
    }

    public void setInstanceTypeName(String instanceTypeName) {
        this.instanceTypeName = instanceTypeName;
    }

    public void accept(Visitor<PlanNode> visitor) {
        for (SinkPlanNode node : this.dataSinks) {
            node.accept(visitor);
        }
    }
}

