/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.compiler.dag.BinaryUnionNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.IterableIterator;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NAryUnionPlanNode
extends PlanNode {
    private final List<Channel> inputs;

    public NAryUnionPlanNode(BinaryUnionNode template, List<Channel> inputs, GlobalProperties gProps) {
        super(template, "Union", DriverStrategy.NONE);
        this.inputs = inputs;
        this.globalProps = gProps;
        this.localProps = new LocalProperties();
    }

    public void accept(Visitor<PlanNode> visitor) {
        visitor.preVisit((Visitable)this);
        for (Channel c : this.inputs) {
            c.getSource().accept(visitor);
        }
        visitor.postVisit((Visitable)this);
    }

    public List<Channel> getListOfInputs() {
        return this.inputs;
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        final Iterator<Channel> channels = this.inputs.iterator();
        return new IterableIterator<PlanNode>(){

            public boolean hasNext() {
                return channels.hasNext();
            }

            public PlanNode next() {
                return ((Channel)channels.next()).getSource();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Iterator<PlanNode> iterator() {
                return this;
            }
        };
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        throw new UnsupportedOperationException();
    }
}

