/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.typeutils.TypeComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypePairComparatorFactory;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.NamedChannel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DamBehavior;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.ArrayList;
import java.util.Arrays;

public class DualInputPlanNode
extends PlanNode {
    protected final Channel input1;
    protected final Channel input2;
    protected final FieldList keys1;
    protected final FieldList keys2;
    protected final boolean[] sortOrders;
    private TypeComparatorFactory<?> comparator1;
    private TypeComparatorFactory<?> comparator2;
    private TypePairComparatorFactory<?, ?> pairComparator;
    public Object postPassHelper1;
    public Object postPassHelper2;

    public DualInputPlanNode(OptimizerNode template, String nodeName, Channel input1, Channel input2, DriverStrategy diverStrategy) {
        this(template, nodeName, input1, input2, diverStrategy, null, null, null);
    }

    public DualInputPlanNode(OptimizerNode template, String nodeName, Channel input1, Channel input2, DriverStrategy diverStrategy, FieldList driverKeyFields1, FieldList driverKeyFields2) {
        this(template, nodeName, input1, input2, diverStrategy, driverKeyFields1, driverKeyFields2, SingleInputPlanNode.getTrueArray(driverKeyFields1.size()));
    }

    public DualInputPlanNode(OptimizerNode template, String nodeName, Channel input1, Channel input2, DriverStrategy diverStrategy, FieldList driverKeyFields1, FieldList driverKeyFields2, boolean[] driverSortOrders) {
        super(template, nodeName, diverStrategy);
        this.input1 = input1;
        this.input2 = input2;
        this.keys1 = driverKeyFields1;
        this.keys2 = driverKeyFields2;
        this.sortOrders = driverSortOrders;
        if (this.input1.getShipStrategy() == ShipStrategyType.BROADCAST) {
            this.input1.setReplicationFactor(this.getDegreeOfParallelism());
        }
        if (this.input2.getShipStrategy() == ShipStrategyType.BROADCAST) {
            this.input2.setReplicationFactor(this.getDegreeOfParallelism());
        }
        this.mergeBranchPlanMaps(input1.getSource(), input2.getSource());
    }

    public TwoInputNode getTwoInputNode() {
        if (this.template instanceof TwoInputNode) {
            return (TwoInputNode)this.template;
        }
        throw new RuntimeException();
    }

    public FieldList getKeysForInput1() {
        return this.keys1;
    }

    public FieldList getKeysForInput2() {
        return this.keys2;
    }

    public boolean[] getSortOrders() {
        return this.sortOrders;
    }

    public TypeComparatorFactory<?> getComparator1() {
        return this.comparator1;
    }

    public TypeComparatorFactory<?> getComparator2() {
        return this.comparator2;
    }

    public void setComparator1(TypeComparatorFactory<?> comparator) {
        this.comparator1 = comparator;
    }

    public void setComparator2(TypeComparatorFactory<?> comparator) {
        this.comparator2 = comparator;
    }

    public TypePairComparatorFactory<?, ?> getPairComparator() {
        return this.pairComparator;
    }

    public void setPairComparator(TypePairComparatorFactory<?, ?> comparator) {
        this.pairComparator = comparator;
    }

    public Channel getInput1() {
        return this.input1;
    }

    public Channel getInput2() {
        return this.input2;
    }

    public void accept(Visitor<PlanNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            this.input1.getSource().accept(visitor);
            this.input2.getSource().accept(visitor);
            for (Channel channel : this.getBroadcastInputs()) {
                channel.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        if (this.getBroadcastInputs() == null || this.getBroadcastInputs().isEmpty()) {
            return Arrays.asList(this.input1.getSource(), this.input2.getSource());
        }
        ArrayList<PlanNode> preds = new ArrayList<PlanNode>();
        preds.add(this.input1.getSource());
        preds.add(this.input2.getSource());
        for (Channel channel : this.getBroadcastInputs()) {
            preds.add(channel.getSource());
        }
        return preds;
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Arrays.asList(this.input1, this.input2);
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport res1 = this.input1.getSource().hasDamOnPathDownTo(source);
        if (res1 == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (res1 == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            if (this.input1.getLocalStrategy().dams() || this.input1.getTempMode().breaksPipeline() || this.getDriverStrategy().firstDam() == DamBehavior.FULL_DAM) {
                return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
            }
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport res2 = this.input2.getSource().hasDamOnPathDownTo(source);
        if (res2 == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (res2 == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            if (this.input2.getLocalStrategy().dams() || this.input2.getTempMode().breaksPipeline() || this.getDriverStrategy().secondDam() == DamBehavior.FULL_DAM) {
                return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
            }
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        for (NamedChannel nc : this.getBroadcastInputs()) {
            PlanNode.SourceAndDamReport bcRes = nc.getSource().hasDamOnPathDownTo(source);
            if (bcRes == PlanNode.SourceAndDamReport.NOT_FOUND) continue;
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        return PlanNode.SourceAndDamReport.NOT_FOUND;
    }
}

