/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.plan;

import eu.stratosphere.api.common.typeutils.TypeSerializerFactory;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.costs.Costs;
import eu.stratosphere.compiler.dag.BulkIterationNode;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.plan.BulkPartialSolutionPlanNode;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.IterationPlanNode;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.util.Visitor;
import java.util.HashMap;

public class BulkIterationPlanNode
extends SingleInputPlanNode
implements IterationPlanNode {
    private final BulkPartialSolutionPlanNode partialSolutionPlanNode;
    private final PlanNode rootOfStepFunction;
    private PlanNode rootOfTerminationCriterion;
    private TypeSerializerFactory<?> serializerForIterationChannel;

    public BulkIterationPlanNode(BulkIterationNode template, String nodeName, Channel input, BulkPartialSolutionPlanNode pspn, PlanNode rootOfStepFunction) {
        super(template, nodeName, input, DriverStrategy.NONE);
        this.partialSolutionPlanNode = pspn;
        this.rootOfStepFunction = rootOfStepFunction;
        this.mergeBranchPlanMaps();
    }

    public BulkIterationPlanNode(BulkIterationNode template, String nodeName, Channel input, BulkPartialSolutionPlanNode pspn, PlanNode rootOfStepFunction, PlanNode rootOfTerminationCriterion) {
        this(template, nodeName, input, pspn, rootOfStepFunction);
        this.rootOfTerminationCriterion = rootOfTerminationCriterion;
    }

    @Override
    public BulkIterationNode getIterationNode() {
        if (this.template instanceof BulkIterationNode) {
            return (BulkIterationNode)this.template;
        }
        throw new RuntimeException();
    }

    public BulkPartialSolutionPlanNode getPartialSolutionPlanNode() {
        return this.partialSolutionPlanNode;
    }

    public PlanNode getRootOfStepFunction() {
        return this.rootOfStepFunction;
    }

    public PlanNode getRootOfTerminationCriterion() {
        return this.rootOfTerminationCriterion;
    }

    public TypeSerializerFactory<?> getSerializerForIterationChannel() {
        return this.serializerForIterationChannel;
    }

    public void setSerializerForIterationChannel(TypeSerializerFactory<?> serializerForIterationChannel) {
        this.serializerForIterationChannel = serializerForIterationChannel;
    }

    @Override
    public void setCosts(Costs nodeCosts) {
        nodeCosts.addCosts(this.rootOfStepFunction.getCumulativeCosts());
        if (this.rootOfTerminationCriterion != null) {
            nodeCosts.addCosts(this.rootOfTerminationCriterion.getCumulativeCosts());
        }
        super.setCosts(nodeCosts);
    }

    @Override
    public int getMemoryConsumerWeight() {
        return 1;
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        PlanNode.SourceAndDamReport fromOutside = super.hasDamOnPathDownTo(source);
        if (fromOutside == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        if (fromOutside == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM;
        }
        return this.rootOfStepFunction.hasDamOnPathDownTo(source);
    }

    @Override
    public void acceptForStepFunction(Visitor<PlanNode> visitor) {
        this.rootOfStepFunction.accept(visitor);
        if (this.rootOfTerminationCriterion != null) {
            this.rootOfTerminationCriterion.accept(visitor);
        }
    }

    private void mergeBranchPlanMaps() {
        for (OptimizerNode.UnclosedBranchDescriptor desc : this.template.getOpenBranches()) {
            OptimizerNode brancher = desc.getBranchingNode();
            if (this.branchPlan == null) {
                this.branchPlan = new HashMap(6);
            }
            if (this.branchPlan.containsKey(brancher)) continue;
            PlanNode selectedCandidate = null;
            if (this.rootOfStepFunction.branchPlan != null) {
                selectedCandidate = this.rootOfStepFunction.branchPlan.get(brancher);
            }
            if (selectedCandidate == null) {
                throw new CompilerException("Candidates for a node with open branches are missing information about the selected candidate ");
            }
            this.branchPlan.put(brancher, selectedCandidate);
        }
    }
}

