/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.operators;

import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.AbstractOperatorDescriptor;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import java.util.List;

public abstract class OperatorDescriptorDual
implements AbstractOperatorDescriptor {
    protected final FieldList keys1;
    protected final FieldList keys2;
    private List<GlobalPropertiesPair> globalProps;
    private List<LocalPropertiesPair> localProps;

    protected OperatorDescriptorDual() {
        this(null, null);
    }

    protected OperatorDescriptorDual(FieldList keys1, FieldList keys2) {
        this.keys1 = keys1;
        this.keys2 = keys2;
    }

    public List<GlobalPropertiesPair> getPossibleGlobalProperties() {
        if (this.globalProps == null) {
            this.globalProps = this.createPossibleGlobalProperties();
        }
        return this.globalProps;
    }

    public List<LocalPropertiesPair> getPossibleLocalProperties() {
        if (this.localProps == null) {
            this.localProps = this.createPossibleLocalProperties();
        }
        return this.localProps;
    }

    protected abstract List<GlobalPropertiesPair> createPossibleGlobalProperties();

    protected abstract List<LocalPropertiesPair> createPossibleLocalProperties();

    public abstract boolean areCoFulfilled(RequestedLocalProperties var1, RequestedLocalProperties var2, LocalProperties var3, LocalProperties var4);

    public abstract DualInputPlanNode instantiate(Channel var1, Channel var2, TwoInputNode var3);

    public abstract GlobalProperties computeGlobalProperties(GlobalProperties var1, GlobalProperties var2);

    public abstract LocalProperties computeLocalProperties(LocalProperties var1, LocalProperties var2);

    public static final class LocalPropertiesPair {
        private final RequestedLocalProperties props1;
        private final RequestedLocalProperties props2;

        public LocalPropertiesPair(RequestedLocalProperties props1, RequestedLocalProperties props2) {
            this.props1 = props1;
            this.props2 = props2;
        }

        public RequestedLocalProperties getProperties1() {
            return this.props1;
        }

        public RequestedLocalProperties getProperties2() {
            return this.props2;
        }

        public int hashCode() {
            return (this.props1 == null ? 0 : this.props1.hashCode()) ^ (this.props2 == null ? 0 : this.props2.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == LocalPropertiesPair.class) {
                LocalPropertiesPair other = (LocalPropertiesPair)obj;
                return (this.props1 == null ? other.props1 == null : this.props1.equals(other.props1)) && (this.props2 == null ? other.props2 == null : this.props2.equals(other.props2));
            }
            return false;
        }

        public String toString() {
            return "{" + this.props1 + " / " + this.props2 + "}";
        }
    }

    public static final class GlobalPropertiesPair {
        private final RequestedGlobalProperties props1;
        private final RequestedGlobalProperties props2;

        public GlobalPropertiesPair(RequestedGlobalProperties props1, RequestedGlobalProperties props2) {
            this.props1 = props1;
            this.props2 = props2;
        }

        public RequestedGlobalProperties getProperties1() {
            return this.props1;
        }

        public RequestedGlobalProperties getProperties2() {
            return this.props2;
        }

        public int hashCode() {
            return (this.props1 == null ? 0 : this.props1.hashCode()) ^ (this.props2 == null ? 0 : this.props2.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == GlobalPropertiesPair.class) {
                GlobalPropertiesPair other = (GlobalPropertiesPair)obj;
                return (this.props1 == null ? other.props1 == null : this.props1.equals(other.props1)) && (this.props2 == null ? other.props2 == null : this.props2.equals(other.props2));
            }
            return false;
        }

        public String toString() {
            return "{" + this.props1 + " / " + this.props2 + "}";
        }
    }
}

