/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.operators;

import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.AbstractJoinDescriptor;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import java.util.Collections;
import java.util.List;

public final class HashJoinBuildSecondProperties
extends AbstractJoinDescriptor {
    public HashJoinBuildSecondProperties(FieldList keys1, FieldList keys2) {
        super(keys1, keys2);
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.HYBRIDHASH_BUILD_SECOND;
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        DriverStrategy strategy;
        if (!in2.isOnDynamicPath() && in1.isOnDynamicPath()) {
            if (!in2.getTempMode().isCached()) {
                throw new CompilerException("No cache at point where static and dynamic parts meet.");
            }
            in2.setTempMode(in2.getTempMode().makeNonCached());
            strategy = DriverStrategy.HYBRIDHASH_BUILD_SECOND_CACHED;
        } else {
            strategy = DriverStrategy.HYBRIDHASH_BUILD_SECOND;
        }
        return new DualInputPlanNode(node, "Join(" + node.getPactContract().getName() + ")", in1, in2, strategy, this.keys1, this.keys2);
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        return new LocalProperties();
    }
}

