/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.operators;

import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.operators.util.FieldSet;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.PartitioningProperty;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.compiler.util.Utils;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import java.util.Collections;
import java.util.List;

public class CoGroupDescriptor
extends OperatorDescriptorDual {
    private final Ordering ordering1;
    private final Ordering ordering2;

    public CoGroupDescriptor(FieldList keys1, FieldList keys2) {
        this(keys1, keys2, null, null);
    }

    public CoGroupDescriptor(FieldList keys1, FieldList keys2, Ordering additionalOrdering1, Ordering additionalOrdering2) {
        super(keys1, keys2);
        Order order;
        Integer field;
        if (additionalOrdering1 != null) {
            this.ordering1 = new Ordering();
            for (Integer key : this.keys1) {
                this.ordering1.appendOrdering(key, null, Order.ANY);
            }
            for (int i = 0; i < additionalOrdering1.getNumberOfFields(); ++i) {
                field = additionalOrdering1.getFieldNumber(i);
                order = additionalOrdering1.getOrder(i);
                this.ordering1.appendOrdering(field, additionalOrdering1.getType(i), order);
            }
        } else {
            this.ordering1 = Utils.createOrdering(this.keys1);
        }
        if (additionalOrdering2 != null) {
            this.ordering2 = new Ordering();
            for (Integer key : this.keys2) {
                this.ordering2.appendOrdering(key, null, Order.ANY);
            }
            for (int i = 0; i < additionalOrdering2.getNumberOfFields(); ++i) {
                field = additionalOrdering2.getFieldNumber(i);
                order = additionalOrdering2.getOrder(i);
                this.ordering2.appendOrdering(field, additionalOrdering2.getType(i), order);
            }
        } else {
            this.ordering2 = Utils.createOrdering(this.keys2);
        }
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.CO_GROUP;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        RequestedGlobalProperties partitioned1 = new RequestedGlobalProperties();
        partitioned1.setHashPartitioned((FieldSet)this.keys1);
        RequestedGlobalProperties partitioned2 = new RequestedGlobalProperties();
        partitioned2.setHashPartitioned((FieldSet)this.keys2);
        return Collections.singletonList(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned1, partitioned2));
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        RequestedLocalProperties sort1 = new RequestedLocalProperties(this.ordering1);
        RequestedLocalProperties sort2 = new RequestedLocalProperties(this.ordering2);
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(sort1, sort2));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        int numRelevantFields = this.keys1.size();
        Ordering prod1 = produced1.getOrdering();
        Ordering prod2 = produced2.getOrdering();
        if (prod1 == null || prod2 == null || prod1.getNumberOfFields() < numRelevantFields || prod2.getNumberOfFields() < prod2.getNumberOfFields()) {
            throw new CompilerException("The given properties do not meet this operators requirements.");
        }
        for (int i = 0; i < numRelevantFields; ++i) {
            if (prod1.getOrder(i) == prod2.getOrder(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        boolean[] inputOrders;
        boolean[] blArray = inputOrders = in1.getLocalProperties().getOrdering() == null ? null : in1.getLocalProperties().getOrdering().getFieldSortDirections();
        if (inputOrders == null || inputOrders.length < this.keys1.size()) {
            throw new CompilerException("BUG: The input strategy does not sufficiently describe the sort orders for a CoGroup operator.");
        }
        if (inputOrders.length > this.keys1.size()) {
            boolean[] tmp = new boolean[this.keys1.size()];
            System.arraycopy(inputOrders, 0, tmp, 0, tmp.length);
            inputOrders = tmp;
        }
        return new DualInputPlanNode(node, "CoGroup (" + node.getPactContract().getName() + ")", in1, in2, DriverStrategy.CO_GROUP, this.keys1, this.keys2, inputOrders);
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        LocalProperties comb = LocalProperties.combine(in1, in2);
        return comb.clearUniqueFieldSets();
    }
}

