/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.operators;

import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.PartitioningProperty;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CartesianProductDescriptor
extends OperatorDescriptorDual {
    private final boolean allowBroadcastFirst;
    private final boolean allowBroadcastSecond;

    protected CartesianProductDescriptor(boolean allowBroadcastFirst, boolean allowBroadcastSecond) {
        if (!(allowBroadcastFirst | allowBroadcastSecond)) {
            throw new IllegalArgumentException();
        }
        this.allowBroadcastFirst = allowBroadcastFirst;
        this.allowBroadcastSecond = allowBroadcastSecond;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        ArrayList<OperatorDescriptorDual.GlobalPropertiesPair> pairs = new ArrayList<OperatorDescriptorDual.GlobalPropertiesPair>();
        if (this.allowBroadcastFirst) {
            RequestedGlobalProperties replicated1 = new RequestedGlobalProperties();
            replicated1.setFullyReplicated();
            RequestedGlobalProperties any2 = new RequestedGlobalProperties();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(replicated1, any2));
        }
        if (this.allowBroadcastSecond) {
            RequestedGlobalProperties any1 = new RequestedGlobalProperties();
            RequestedGlobalProperties replicated2 = new RequestedGlobalProperties();
            replicated2.setFullyReplicated();
            pairs.add(new OperatorDescriptorDual.GlobalPropertiesPair(any1, replicated2));
        }
        return pairs;
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        return true;
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        return new DualInputPlanNode(node, "Cross(" + node.getPactContract().getName() + ")", in1, in2, this.getStrategy());
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }
}

