/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.operators;

import eu.stratosphere.compiler.costs.Costs;
import eu.stratosphere.compiler.dag.ReduceNode;
import eu.stratosphere.compiler.dag.SingleInputNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorSingle;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import java.util.Collections;
import java.util.List;

public final class AllReduceProperties
extends OperatorDescriptorSingle {
    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.ALL_REDUCE;
    }

    @Override
    public SingleInputPlanNode instantiate(Channel in, SingleInputNode node) {
        if (in.getShipStrategy() == ShipStrategyType.FORWARD) {
            return new SingleInputPlanNode(node, "Reduce (" + node.getPactContract().getName() + ")", in, DriverStrategy.ALL_REDUCE);
        }
        Channel toCombiner = new Channel(in.getSource());
        toCombiner.setShipStrategy(ShipStrategyType.FORWARD);
        ReduceNode combinerNode = ((ReduceNode)node).getCombinerUtilityNode();
        combinerNode.setDegreeOfParallelism(in.getSource().getDegreeOfParallelism());
        SingleInputPlanNode combiner = new SingleInputPlanNode(combinerNode, "Combine (" + node.getPactContract().getName() + ")", toCombiner, DriverStrategy.ALL_REDUCE);
        combiner.setCosts(new Costs(0.0, 0.0));
        combiner.initProperties(toCombiner.getGlobalProperties(), toCombiner.getLocalProperties());
        Channel toReducer = new Channel(combiner);
        toReducer.setShipStrategy(in.getShipStrategy(), in.getShipStrategyKeys(), in.getShipStrategySortOrder());
        toReducer.setLocalStrategy(in.getLocalStrategy(), in.getLocalStrategyKeys(), in.getLocalStrategySortOrder());
        return new SingleInputPlanNode(node, "Reduce(" + node.getPactContract().getName() + ")", toReducer, DriverStrategy.ALL_REDUCE);
    }

    @Override
    protected List<RequestedGlobalProperties> createPossibleGlobalProperties() {
        return Collections.singletonList(new RequestedGlobalProperties());
    }

    @Override
    protected List<RequestedLocalProperties> createPossibleLocalProperties() {
        return Collections.singletonList(new RequestedLocalProperties());
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties gProps) {
        return new GlobalProperties();
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties lProps) {
        return new LocalProperties();
    }
}

