/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dataproperties;

import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.operators.util.FieldSet;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.util.Utils;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import java.util.Arrays;

public class RequestedLocalProperties
implements Cloneable {
    public static final RequestedLocalProperties DEFAULT_PROPERTIES = null;
    private Ordering ordering;
    private FieldSet groupedFields;

    public RequestedLocalProperties() {
    }

    public RequestedLocalProperties(Ordering ordering) {
        this.ordering = ordering;
    }

    public RequestedLocalProperties(FieldSet groupedFields) {
        this.groupedFields = groupedFields;
    }

    private RequestedLocalProperties(Ordering ordering, FieldSet groupedFields) {
        this.ordering = ordering;
        this.groupedFields = groupedFields;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }

    public FieldSet getGroupedFields() {
        return this.groupedFields;
    }

    public void setGroupedFields(FieldSet groupedFields) {
        this.groupedFields = groupedFields;
    }

    public boolean isTrivial() {
        return this.ordering == null && this.groupedFields == null;
    }

    public void reset() {
        this.ordering = null;
        this.groupedFields = null;
    }

    public RequestedLocalProperties filterByNodesConstantSet(OptimizerNode node, int input) {
        block3: {
            block2: {
                if (this.ordering == null) break block2;
                FieldList involvedIndexes = this.ordering.getInvolvedIndexes();
                for (int i = 0; i < involvedIndexes.size(); ++i) {
                    if (node.isFieldConstant(input, involvedIndexes.get(i))) continue;
                    return null;
                }
                break block3;
            }
            if (this.groupedFields == null) break block3;
            for (Integer index : this.groupedFields) {
                if (node.isFieldConstant(input, index)) continue;
                return null;
            }
        }
        return this;
    }

    public boolean isMetBy(LocalProperties other) {
        if (this.ordering != null) {
            return other.getOrdering() != null && this.ordering.isMetBy(other.getOrdering());
        }
        if (this.groupedFields != null) {
            if (other.getGroupedFields() != null && other.getGroupedFields().isValidUnorderedPrefix(this.groupedFields)) {
                return true;
            }
            return other.areFieldsUnique(this.groupedFields);
        }
        return true;
    }

    public void parameterizeChannel(Channel channel) {
        LocalProperties current = channel.getLocalProperties();
        if (this.isMetBy(current)) {
            channel.setLocalStrategy(LocalStrategy.NONE);
        } else if (this.ordering != null) {
            channel.setLocalStrategy(LocalStrategy.SORT, this.ordering.getInvolvedIndexes(), this.ordering.getFieldSortDirections());
        } else if (this.groupedFields != null) {
            boolean[] dirs = new boolean[this.groupedFields.size()];
            Arrays.fill(dirs, true);
            channel.setLocalStrategy(LocalStrategy.SORT, Utils.createOrderedFromSet(this.groupedFields), dirs);
        } else {
            channel.setLocalStrategy(LocalStrategy.NONE);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        result = 31 * result + (this.groupedFields == null ? 0 : this.groupedFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequestedLocalProperties) {
            RequestedLocalProperties other = (RequestedLocalProperties)obj;
            return (this.ordering == other.ordering || this.ordering != null && this.ordering.equals((Object)other.ordering)) && (this.groupedFields == other.groupedFields || this.groupedFields != null && this.groupedFields.equals((Object)other.groupedFields));
        }
        return false;
    }

    public String toString() {
        return "Requested Local Properties [ordering=" + this.ordering + ", grouped=" + this.groupedFields + "]";
    }

    public RequestedLocalProperties clone() {
        return new RequestedLocalProperties(this.ordering, this.groupedFields);
    }
}

