/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dataproperties;

import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.operators.util.FieldSet;
import eu.stratosphere.compiler.dag.OptimizerNode;
import java.util.HashSet;
import java.util.Set;

public class LocalProperties
implements Cloneable {
    public static final LocalProperties EMPTY = new LocalProperties();
    private Ordering ordering;
    private FieldList groupedFields;
    private Set<FieldSet> uniqueFields;

    public Ordering getOrdering() {
        return this.ordering;
    }

    public FieldList getGroupedFields() {
        return this.groupedFields;
    }

    public Set<FieldSet> getUniqueFields() {
        return this.uniqueFields;
    }

    public boolean areFieldsUnique(FieldSet set) {
        return this.uniqueFields != null && this.uniqueFields.contains(set);
    }

    public LocalProperties addUniqueFields(FieldSet uniqueFields) {
        LocalProperties copy = this.clone();
        if (copy.uniqueFields == null) {
            copy.uniqueFields = new HashSet<FieldSet>();
        }
        copy.uniqueFields.add(uniqueFields);
        return copy;
    }

    public LocalProperties clearUniqueFieldSets() {
        if (this.uniqueFields == null || this.uniqueFields.isEmpty()) {
            return this;
        }
        LocalProperties copy = new LocalProperties();
        copy.ordering = this.ordering;
        copy.groupedFields = this.groupedFields;
        return copy;
    }

    public boolean isTrivial() {
        return this.ordering == null && this.groupedFields == null && this.uniqueFields == null;
    }

    public LocalProperties filterByNodesConstantSet(OptimizerNode node, int input) {
        Ordering no = this.ordering;
        FieldList ngf = this.groupedFields;
        Set<FieldSet> nuf = this.uniqueFields;
        if (this.ordering != null) {
            FieldList involvedIndexes = this.ordering.getInvolvedIndexes();
            for (int i = 0; i < involvedIndexes.size(); ++i) {
                if (node.isFieldConstant(input, involvedIndexes.get(i))) continue;
                if (i == 0) {
                    no = null;
                    ngf = null;
                } else {
                    no = this.ordering.createNewOrderingUpToIndex(i);
                    ngf = no.getInvolvedIndexes();
                }
                break;
            }
        } else if (this.groupedFields != null) {
            for (Integer index : this.groupedFields) {
                if (node.isFieldConstant(input, index)) continue;
                ngf = null;
            }
        }
        if (this.uniqueFields != null && this.uniqueFields.size() > 0) {
            HashSet<FieldSet> s = new HashSet<FieldSet>(this.uniqueFields);
            block2: for (FieldSet fields : this.uniqueFields) {
                for (Integer index : fields) {
                    if (node.isFieldConstant(input, index)) continue;
                    s.remove(fields);
                    continue block2;
                }
            }
            if (s.size() != this.uniqueFields.size()) {
                nuf = s;
            }
        }
        if (no == this.ordering && ngf == this.groupedFields && nuf == this.uniqueFields) {
            return this;
        }
        LocalProperties lp = new LocalProperties();
        lp.ordering = no;
        lp.groupedFields = ngf;
        lp.uniqueFields = nuf;
        return lp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        result = 31 * result + (this.groupedFields == null ? 0 : this.groupedFields.hashCode());
        result = 31 * result + (this.uniqueFields == null ? 0 : this.uniqueFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalProperties) {
            LocalProperties other = (LocalProperties)obj;
            return (this.ordering == other.getOrdering() || this.ordering != null && this.ordering.equals((Object)other.getOrdering())) && (this.groupedFields == other.getGroupedFields() || this.groupedFields != null && this.groupedFields.equals((Object)other.getGroupedFields())) && (this.uniqueFields == other.getUniqueFields() || this.uniqueFields != null && this.uniqueFields.equals(other.getUniqueFields()));
        }
        return false;
    }

    public String toString() {
        return "LocalProperties [ordering=" + this.ordering + ", grouped=" + this.groupedFields + ", unique=" + this.uniqueFields + "]";
    }

    public LocalProperties clone() {
        LocalProperties copy = new LocalProperties();
        copy.ordering = this.ordering;
        copy.groupedFields = this.groupedFields;
        copy.uniqueFields = this.uniqueFields == null ? null : new HashSet<FieldSet>(this.uniqueFields);
        return copy;
    }

    public static LocalProperties combine(LocalProperties lp1, LocalProperties lp2) {
        if (lp1.ordering != null) {
            return lp1;
        }
        if (lp2.ordering != null) {
            return lp2;
        }
        if (lp1.groupedFields != null) {
            return lp1;
        }
        if (lp2.groupedFields != null) {
            return lp2;
        }
        if (lp1.uniqueFields != null && !lp1.uniqueFields.isEmpty()) {
            return lp1;
        }
        if (lp2.uniqueFields != null && !lp2.uniqueFields.isEmpty()) {
            return lp2;
        }
        return lp1;
    }

    public static LocalProperties forOrdering(Ordering o) {
        LocalProperties props = new LocalProperties();
        props.ordering = o;
        props.groupedFields = o.getInvolvedIndexes();
        return props;
    }

    public static LocalProperties forGrouping(FieldList groupedFields) {
        LocalProperties props = new LocalProperties();
        props.groupedFields = groupedFields;
        return props;
    }
}

