/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dataproperties;

import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InterestingProperties
implements Cloneable {
    private Set<RequestedGlobalProperties> globalProps;
    private Set<RequestedLocalProperties> localProps;

    public InterestingProperties() {
        this.globalProps = new HashSet<RequestedGlobalProperties>();
        this.localProps = new HashSet<RequestedLocalProperties>();
    }

    private InterestingProperties(Set<RequestedGlobalProperties> globalProps, Set<RequestedLocalProperties> localProps) {
        this.globalProps = globalProps;
        this.localProps = localProps;
    }

    public void addGlobalProperties(RequestedGlobalProperties props) {
        this.globalProps.add(props);
    }

    public void addLocalProperties(RequestedLocalProperties props) {
        this.localProps.add(props);
    }

    public void addInterestingProperties(InterestingProperties other) {
        this.globalProps.addAll(other.globalProps);
        this.localProps.addAll(other.localProps);
    }

    public Set<RequestedLocalProperties> getLocalProperties() {
        return this.localProps;
    }

    public Set<RequestedGlobalProperties> getGlobalProperties() {
        return this.globalProps;
    }

    public InterestingProperties filterByCodeAnnotations(OptimizerNode node, int input) {
        Cloneable filtered;
        InterestingProperties iProps = new InterestingProperties();
        for (RequestedGlobalProperties rgp : this.globalProps) {
            filtered = rgp.filterByNodesConstantSet(node, input);
            if (filtered == null || ((RequestedGlobalProperties)filtered).isTrivial()) continue;
            iProps.addGlobalProperties((RequestedGlobalProperties)filtered);
        }
        for (RequestedLocalProperties rlp : this.localProps) {
            filtered = rlp.filterByNodesConstantSet(node, input);
            if (filtered == null || ((RequestedLocalProperties)filtered).isTrivial()) continue;
            iProps.addLocalProperties((RequestedLocalProperties)filtered);
        }
        return iProps;
    }

    public void dropTrivials() {
        Iterator<Cloneable> iter = this.globalProps.iterator();
        while (iter.hasNext()) {
            RequestedGlobalProperties gp = iter.next();
            if (!gp.isTrivial()) continue;
            iter.remove();
            break;
        }
        iter = this.localProps.iterator();
        while (iter.hasNext()) {
            RequestedLocalProperties lp = (RequestedLocalProperties)iter.next();
            if (!lp.isTrivial()) continue;
            iter.remove();
            break;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.globalProps == null ? 0 : this.globalProps.hashCode());
        result = 31 * result + (this.localProps == null ? 0 : this.localProps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof InterestingProperties) {
            InterestingProperties other = (InterestingProperties)obj;
            return this.globalProps.equals(other.globalProps) && this.localProps.equals(other.localProps);
        }
        return false;
    }

    public String toString() {
        return "InterestingProperties [globalProps=" + this.globalProps + ", localProps=" + this.localProps + " ]";
    }

    public InterestingProperties clone() {
        HashSet<RequestedGlobalProperties> globalProps = new HashSet<RequestedGlobalProperties>();
        for (RequestedGlobalProperties p : this.globalProps) {
            globalProps.add(p.clone());
        }
        HashSet<RequestedLocalProperties> localProps = new HashSet<RequestedLocalProperties>();
        for (RequestedLocalProperties p : this.localProps) {
            localProps.add(p.clone());
        }
        return new InterestingProperties(globalProps, localProps);
    }
}

