/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.base.DeltaIterationBase;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.AbstractPartialSolutionNode;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.WorksetIterationNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.WorksetPlanNode;
import java.util.Collections;
import java.util.List;

public class WorksetNode
extends AbstractPartialSolutionNode {
    private final WorksetIterationNode iterationNode;

    public WorksetNode(DeltaIterationBase.WorksetPlaceHolder<?> psph, WorksetIterationNode iterationNode) {
        super((Operator<?>)psph);
        this.iterationNode = iterationNode;
    }

    public void setCandidateProperties(GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        if (this.cachedPlans != null) {
            throw new IllegalStateException();
        }
        WorksetPlanNode wspn = new WorksetPlanNode(this, "Workset (" + this.getPactContract().getName() + ")", gProps, lProps, initialInput);
        this.cachedPlans = Collections.singletonList(wspn);
    }

    public WorksetPlanNode getCurrentWorksetPlanNode() {
        if (this.cachedPlans != null) {
            return (WorksetPlanNode)this.cachedPlans.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public WorksetIterationNode getIterationNode() {
        return this.iterationNode;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        this.copyEstimates(this.iterationNode.getInitialWorksetPredecessorNode());
    }

    public DeltaIterationBase.WorksetPlaceHolder<?> getPactContract() {
        return (DeltaIterationBase.WorksetPlaceHolder)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Workset";
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        PactConnection worksetInput = this.iterationNode.getSecondIncomingConnection();
        OptimizerNode worksetSource = worksetInput.getSource();
        this.addClosedBranches(worksetSource.closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = worksetSource.getBranchesForParent(worksetInput);
        this.openBranches = fromInput == null || fromInput.isEmpty() ? Collections.emptyList() : fromInput;
    }
}

