/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.base.DeltaIterationBase;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.common.operators.util.FieldSet;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.costs.CostEstimator;
import eu.stratosphere.compiler.dag.InterestingPropertiesClearer;
import eu.stratosphere.compiler.dag.IterationNode;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.PlanCacheCleaner;
import eu.stratosphere.compiler.dag.SolutionSetNode;
import eu.stratosphere.compiler.dag.TempMode;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dag.UnaryOperatorNode;
import eu.stratosphere.compiler.dag.WorksetNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.InterestingProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.dataproperties.PartitioningProperty;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.operators.OperatorDescriptorSingle;
import eu.stratosphere.compiler.operators.SolutionSetDeltaOperator;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.DualInputPlanNode;
import eu.stratosphere.compiler.plan.NamedChannel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.compiler.plan.SolutionSetPlanNode;
import eu.stratosphere.compiler.plan.WorksetIterationPlanNode;
import eu.stratosphere.compiler.plan.WorksetPlanNode;
import eu.stratosphere.compiler.util.NoOpBinaryUdfOp;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.types.NothingTypeInfo;
import eu.stratosphere.util.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WorksetIterationNode
extends TwoInputNode
implements IterationNode {
    private static final int DEFAULT_COST_WEIGHT = 20;
    private final FieldList solutionSetKeyFields;
    private final GlobalProperties partitionedProperties;
    private SolutionSetNode solutionSetNode;
    private WorksetNode worksetNode;
    private OptimizerNode solutionSetDelta;
    private OptimizerNode nextWorkset;
    private PactConnection solutionSetDeltaRootConnection;
    private PactConnection nextWorksetRootConnection;
    private SingleRootJoiner singleRoot;
    private boolean solutionDeltaImmediatelyAfterSolutionJoin;
    private final int costWeight;

    public WorksetIterationNode(DeltaIterationBase<?, ?> iteration) {
        super((DualInputOperator<?, ?, ?, ?>)iteration);
        int weight;
        int[] ssKeys = iteration.getSolutionSetKeyFields();
        if (ssKeys == null || ssKeys.length == 0) {
            throw new CompilerException("Invalid WorksetIteration: No key fields defined for the solution set.");
        }
        this.solutionSetKeyFields = new FieldList(ssKeys);
        this.partitionedProperties = new GlobalProperties();
        this.partitionedProperties.setHashPartitioned(this.solutionSetKeyFields);
        int n = weight = iteration.getMaximumNumberOfIterations() > 0 ? iteration.getMaximumNumberOfIterations() : 20;
        if (weight > 100) {
            weight = 100;
        }
        this.costWeight = weight;
        this.possibleProperties.add(new WorksetOpDescriptor(this.solutionSetKeyFields));
    }

    public DeltaIterationBase<?, ?> getIterationContract() {
        return (DeltaIterationBase)this.getPactContract();
    }

    public SolutionSetNode getSolutionSetNode() {
        return this.solutionSetNode;
    }

    public WorksetNode getWorksetNode() {
        return this.worksetNode;
    }

    public OptimizerNode getNextWorkset() {
        return this.nextWorkset;
    }

    public OptimizerNode getSolutionSetDelta() {
        return this.solutionSetDelta;
    }

    public void setPartialSolution(SolutionSetNode solutionSetNode, WorksetNode worksetNode) {
        if (this.solutionSetNode != null || this.worksetNode != null) {
            throw new IllegalStateException("Error: Initializing WorksetIterationNode multiple times.");
        }
        this.solutionSetNode = solutionSetNode;
        this.worksetNode = worksetNode;
    }

    public void setNextPartialSolution(OptimizerNode solutionSetDelta, OptimizerNode nextWorkset) {
        TwoInputNode solutionDeltaTwoInput;
        if (solutionSetDelta instanceof TwoInputNode && ((solutionDeltaTwoInput = (TwoInputNode)solutionSetDelta).getFirstPredecessorNode() == this.solutionSetNode || solutionDeltaTwoInput.getSecondPredecessorNode() == this.solutionSetNode)) {
            this.solutionDeltaImmediatelyAfterSolutionJoin = true;
        }
        UnaryOperatorNode solutionSetDeltaUpdateAux = new UnaryOperatorNode("Solution-Set Delta", (FieldSet)this.getSolutionSetKeyFields(), new SolutionSetDeltaOperator(this.getSolutionSetKeyFields()));
        solutionSetDeltaUpdateAux.setDegreeOfParallelism(this.getDegreeOfParallelism());
        PactConnection conn = new PactConnection(solutionSetDelta, solutionSetDeltaUpdateAux);
        solutionSetDeltaUpdateAux.setIncomingConnection(conn);
        solutionSetDelta.addOutgoingConnection(conn);
        this.solutionSetDelta = solutionSetDeltaUpdateAux;
        this.nextWorkset = nextWorkset;
        this.singleRoot = new SingleRootJoiner();
        this.solutionSetDeltaRootConnection = new PactConnection(solutionSetDeltaUpdateAux, this.singleRoot);
        this.nextWorksetRootConnection = new PactConnection(nextWorkset, this.singleRoot);
        this.singleRoot.setInputs(this.solutionSetDeltaRootConnection, this.nextWorksetRootConnection);
        solutionSetDeltaUpdateAux.addOutgoingConnection(this.solutionSetDeltaRootConnection);
        nextWorkset.addOutgoingConnection(this.nextWorksetRootConnection);
    }

    @Override
    public int getCostWeight() {
        return this.costWeight;
    }

    public TwoInputNode getSingleRootOfStepFunction() {
        return this.singleRoot;
    }

    public FieldList getSolutionSetKeyFields() {
        return this.solutionSetKeyFields;
    }

    public OptimizerNode getInitialSolutionSetPredecessorNode() {
        return this.getFirstPredecessorNode();
    }

    public OptimizerNode getInitialWorksetPredecessorNode() {
        return this.getSecondPredecessorNode();
    }

    @Override
    public String getName() {
        return "Workset Iteration";
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return false;
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedOutputSize = this.getFirstPredecessorNode().getEstimatedOutputSize();
        this.estimatedNumRecords = this.getFirstPredecessorNode().getEstimatedNumRecords();
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return new ArrayList<OperatorDescriptorDual>(1);
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        RequestedGlobalProperties partitionedProperties = new RequestedGlobalProperties();
        partitionedProperties.setHashPartitioned((FieldSet)this.solutionSetKeyFields);
        InterestingProperties partitionedIP = new InterestingProperties();
        partitionedIP.addGlobalProperties(partitionedProperties);
        partitionedIP.addLocalProperties(new RequestedLocalProperties());
        this.nextWorksetRootConnection.setInterestingProperties(new InterestingProperties());
        this.solutionSetDeltaRootConnection.setInterestingProperties(partitionedIP.clone());
        PactCompiler.InterestingPropertyVisitor ipv = new PactCompiler.InterestingPropertyVisitor(estimator);
        this.nextWorkset.accept(ipv);
        this.solutionSetDelta.accept(ipv);
        InterestingProperties worksetIntProps = this.worksetNode.getInterestingProperties();
        InterestingProperties intProps = new InterestingProperties();
        intProps.getGlobalProperties().addAll(worksetIntProps.getGlobalProperties());
        intProps.getLocalProperties().addAll(worksetIntProps.getLocalProperties());
        this.nextWorksetRootConnection.clearInterestingProperties();
        this.nextWorkset.accept(InterestingPropertiesClearer.INSTANCE);
        this.nextWorksetRootConnection.setInterestingProperties(intProps);
        this.nextWorkset.accept(ipv);
        InterestingProperties inProps = this.worksetNode.getInterestingProperties().clone();
        inProps.addGlobalProperties(new RequestedGlobalProperties());
        inProps.addLocalProperties(new RequestedLocalProperties());
        this.input2.setInterestingProperties(inProps);
        this.input1.setInterestingProperties(partitionedIP);
    }

    @Override
    protected void instantiate(OperatorDescriptorDual operator, Channel solutionSetIn, Channel worksetIn, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReqSolutionSet, RequestedGlobalProperties globPropsReqWorkset, RequestedLocalProperties locPropsReqSolutionSet, RequestedLocalProperties locPropsReqWorkset) {
        this.placePipelineBreakersIfNecessary(DriverStrategy.HYBRIDHASH_BUILD_FIRST, solutionSetIn, worksetIn);
        this.nextWorkset.accept(PlanCacheCleaner.INSTANCE);
        this.solutionSetDelta.accept(PlanCacheCleaner.INSTANCE);
        this.worksetNode.setCandidateProperties(worksetIn.getGlobalProperties(), worksetIn.getLocalProperties(), worksetIn);
        this.solutionSetNode.setCandidateProperties(this.partitionedProperties, new LocalProperties(), solutionSetIn);
        SolutionSetPlanNode sspn = this.solutionSetNode.getCurrentSolutionSetPlanNode();
        WorksetPlanNode wspn = this.worksetNode.getCurrentWorksetPlanNode();
        List<PlanNode> solutionSetDeltaCandidates = this.solutionSetDelta.getAlternativePlans(estimator);
        List<PlanNode> worksetCandidates = this.nextWorkset.getAlternativePlans(estimator);
        ArrayList<SingleInputPlanNode> newCandidates = new ArrayList<SingleInputPlanNode>();
        Iterator<PlanNode> iterator = worksetCandidates.iterator();
        while (iterator.hasNext()) {
            PlanNode.FeedbackPropertiesMeetRequirementsReport report2;
            LocalProperties atEndLocal;
            GlobalProperties atEndGlobal;
            PlanNode candidate = iterator.next();
            PlanNode.FeedbackPropertiesMeetRequirementsReport report = candidate.checkPartialSolutionPropertiesMet(wspn, atEndGlobal = candidate.getGlobalProperties(), atEndLocal = candidate.getLocalProperties());
            if (report == PlanNode.FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION || report != PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET) continue;
            Channel toNoOp = new Channel(candidate);
            globPropsReqWorkset.parameterizeChannel(toNoOp, false);
            locPropsReqWorkset.parameterizeChannel(toNoOp);
            UnaryOperatorNode rebuildWorksetPropertiesNode = new UnaryOperatorNode("Rebuild Workset Properties", (FieldSet)FieldList.EMPTY_LIST, new OperatorDescriptorSingle[0]);
            rebuildWorksetPropertiesNode.setDegreeOfParallelism(candidate.getDegreeOfParallelism());
            SingleInputPlanNode rebuildWorksetPropertiesPlanNode = new SingleInputPlanNode(rebuildWorksetPropertiesNode, "Rebuild Workset Properties", toNoOp, DriverStrategy.UNARY_NO_OP);
            rebuildWorksetPropertiesPlanNode.initProperties(toNoOp.getGlobalProperties(), toNoOp.getLocalProperties());
            estimator.costOperator(rebuildWorksetPropertiesPlanNode);
            GlobalProperties atEndGlobalModified = rebuildWorksetPropertiesPlanNode.getGlobalProperties();
            LocalProperties atEndLocalModified = rebuildWorksetPropertiesPlanNode.getLocalProperties();
            if (!(atEndGlobalModified.equals(atEndGlobal) && atEndLocalModified.equals(atEndLocal) || (report2 = candidate.checkPartialSolutionPropertiesMet(wspn, atEndGlobalModified, atEndLocalModified)) == PlanNode.FeedbackPropertiesMeetRequirementsReport.NOT_MET)) {
                newCandidates.add(rebuildWorksetPropertiesPlanNode);
            }
            iterator.remove();
        }
        worksetCandidates.addAll(newCandidates);
        if (worksetCandidates.isEmpty()) {
            return;
        }
        for (SingleInputPlanNode singleInputPlanNode : solutionSetDeltaCandidates) {
            GlobalProperties gp = singleInputPlanNode.getGlobalProperties();
            if (gp.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && gp.getPartitioningFields() != null && gp.getPartitioningFields().equals((Object)this.solutionSetKeyFields)) continue;
            throw new CompilerException("Bug: The solution set delta is not partitioned.");
        }
        GlobalProperties gp = new GlobalProperties();
        gp.setHashPartitioned(this.solutionSetKeyFields);
        gp.addUniqueFieldCombination((FieldSet)this.solutionSetKeyFields);
        LocalProperties localProperties = LocalProperties.EMPTY.addUniqueFields((FieldSet)this.solutionSetKeyFields);
        for (PlanNode solutionSetCandidate : solutionSetDeltaCandidates) {
            for (PlanNode worksetCandidate : worksetCandidates) {
                boolean immediateDeltaUpdate;
                if (!this.singleRoot.areBranchCompatible(solutionSetCandidate, worksetCandidate)) continue;
                SingleInputPlanNode siSolutionDeltaCandidate = (SingleInputPlanNode)solutionSetCandidate;
                if (siSolutionDeltaCandidate.getInput().getShipStrategy() == ShipStrategyType.FORWARD && this.solutionDeltaImmediatelyAfterSolutionJoin) {
                    if (siSolutionDeltaCandidate.getDriverStrategy() != DriverStrategy.UNARY_NO_OP || siSolutionDeltaCandidate.getInput().getLocalStrategy() != LocalStrategy.NONE) {
                        throw new CompilerException("Invalid Solution set delta node.");
                    }
                    solutionSetCandidate = siSolutionDeltaCandidate.getInput().getSource();
                    immediateDeltaUpdate = true;
                } else {
                    siSolutionDeltaCandidate.getInput().setTempMode(TempMode.PIPELINE_BREAKER);
                    immediateDeltaUpdate = false;
                }
                WorksetIterationPlanNode wsNode = new WorksetIterationPlanNode(this, "WorksetIteration (" + this.getPactContract().getName() + ")", solutionSetIn, worksetIn, sspn, wspn, worksetCandidate, solutionSetCandidate);
                wsNode.setImmediateSolutionSetUpdate(immediateDeltaUpdate);
                wsNode.initProperties(gp, localProperties);
                target.add(wsNode);
            }
        }
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getFirstPredecessorNode().closedBranchingNodes);
        this.addClosedBranches(this.getSecondPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> result1 = this.getFirstPredecessorNode().getBranchesForParent(this.getFirstIncomingConnection());
        List<OptimizerNode.UnclosedBranchDescriptor> result2 = this.getSecondPredecessorNode().getBranchesForParent(this.getSecondIncomingConnection());
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> inputsMerged1 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        this.mergeLists(result1, result2, inputsMerged1);
        this.addClosedBranches(this.getSingleRootOfStepFunction().closedBranchingNodes);
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> inputsMerged2 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        List result3 = this.getSingleRootOfStepFunction().openBranches;
        this.mergeLists(inputsMerged1, result3, inputsMerged2);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.computeUnclosedBranchStackForBroadcastInputs(inputsMerged2);
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public void acceptForStepFunction(Visitor<OptimizerNode> visitor) {
        this.singleRoot.accept(visitor);
    }

    public static class SingleRootJoiner
    extends TwoInputNode {
        SingleRootJoiner() {
            super(new NoOpBinaryUdfOp(new NothingTypeInfo()));
            this.setDegreeOfParallelism(1);
        }

        public void setInputs(PactConnection input1, PactConnection input2) {
            this.input1 = input1;
            this.input2 = input2;
        }

        @Override
        public String getName() {
            return "Internal Utility Node";
        }

        @Override
        protected List<OperatorDescriptorDual> getPossibleProperties() {
            return Collections.emptyList();
        }

        @Override
        protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        }
    }

    private static final class WorksetOpDescriptor
    extends OperatorDescriptorDual {
        private WorksetOpDescriptor(FieldList solutionSetKeys) {
            super(solutionSetKeys, null);
        }

        @Override
        public DriverStrategy getStrategy() {
            return DriverStrategy.NONE;
        }

        @Override
        protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
            RequestedGlobalProperties partitionedGp = new RequestedGlobalProperties();
            partitionedGp.setHashPartitioned((FieldSet)this.keys1);
            return Collections.singletonList(new OperatorDescriptorDual.GlobalPropertiesPair(partitionedGp, new RequestedGlobalProperties()));
        }

        @Override
        protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
            return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(new RequestedLocalProperties(), new RequestedLocalProperties()));
        }

        @Override
        public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
            return true;
        }

        @Override
        public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
            throw new UnsupportedOperationException();
        }
    }
}

