/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.base.DeltaIterationBase;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.AbstractPartialSolutionNode;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.WorksetIterationNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.LocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.SolutionSetPlanNode;
import java.util.Collections;
import java.util.List;

public class SolutionSetNode
extends AbstractPartialSolutionNode {
    private final WorksetIterationNode iterationNode;

    public SolutionSetNode(DeltaIterationBase.SolutionSetPlaceHolder<?> psph, WorksetIterationNode iterationNode) {
        super((Operator<?>)psph);
        this.iterationNode = iterationNode;
    }

    public void setCandidateProperties(GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        if (this.cachedPlans != null) {
            throw new IllegalStateException();
        }
        this.cachedPlans = Collections.singletonList(new SolutionSetPlanNode(this, "SolutionSet(" + this.getPactContract().getName() + ")", gProps, lProps, initialInput));
    }

    public SolutionSetPlanNode getCurrentSolutionSetPlanNode() {
        if (this.cachedPlans != null) {
            return (SolutionSetPlanNode)this.cachedPlans.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public WorksetIterationNode getIterationNode() {
        return this.iterationNode;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        this.copyEstimates(this.iterationNode.getInitialSolutionSetPredecessorNode());
    }

    public DeltaIterationBase.SolutionSetPlaceHolder<?> getPactContract() {
        return (DeltaIterationBase.SolutionSetPlaceHolder)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Solution Set";
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        PactConnection solutionSetInput = this.iterationNode.getFirstIncomingConnection();
        OptimizerNode solutionSetSource = solutionSetInput.getSource();
        this.addClosedBranches(solutionSetSource.closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = solutionSetSource.getBranchesForParent(solutionSetInput);
        this.openBranches = fromInput == null || fromInput.isEmpty() ? Collections.emptyList() : fromInput;
    }
}

