/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.operators.UtilSinkJoinOpDescriptor;
import eu.stratosphere.compiler.util.NoOpBinaryUdfOp;
import eu.stratosphere.types.NothingTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SinkJoiner
extends TwoInputNode {
    public SinkJoiner(OptimizerNode input1, OptimizerNode input2) {
        super(new NoOpBinaryUdfOp(new NothingTypeInfo()));
        PactConnection conn1 = new PactConnection(input1, this);
        PactConnection conn2 = new PactConnection(input2, this);
        this.input1 = conn1;
        this.input2 = conn2;
        this.setDegreeOfParallelism(1);
    }

    @Override
    public String getName() {
        return "Internal Utility Node";
    }

    @Override
    public List<PactConnection> getOutgoingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getFirstPredecessorNode().closedBranchingNodes);
        this.addClosedBranches(this.getSecondPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> pred1branches = this.getFirstPredecessorNode().openBranches;
        List<OptimizerNode.UnclosedBranchDescriptor> pred2branches = this.getSecondPredecessorNode().openBranches;
        if (pred1branches == null || pred1branches.isEmpty() || pred2branches == null || pred2branches.isEmpty()) {
            throw new CompilerException("The given program contains multiple disconnected data flows.");
        }
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> result1 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>(pred1branches);
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> result2 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>(pred2branches);
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> result = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        this.mergeLists(result1, result2, result);
        this.openBranches = result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return Collections.singletonList(new UtilSinkJoinOpDescriptor());
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }
}

