/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.base.JoinOperatorBase;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.operators.AbstractJoinDescriptor;
import eu.stratosphere.compiler.operators.HashJoinBuildFirstProperties;
import eu.stratosphere.compiler.operators.HashJoinBuildSecondProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.operators.SortMergeJoinDescriptor;
import eu.stratosphere.configuration.Configuration;
import java.util.ArrayList;
import java.util.List;

public class MatchNode
extends TwoInputNode {
    public MatchNode(JoinOperatorBase<?, ?, ?, ?> pactContract) {
        super((DualInputOperator<?, ?, ?, ?>)pactContract);
    }

    public JoinOperatorBase<?, ?, ?, ?> getPactContract() {
        return (JoinOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Join";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        Configuration conf = this.getPactContract().getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            AbstractJoinDescriptor fixedDriverStrat;
            if ("LOCAL_STRATEGY_SORT_BOTH_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_SORT_FIRST_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_SORT_SECOND_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_MERGE".equals(localStrategy)) {
                fixedDriverStrat = new SortMergeJoinDescriptor(this.keys1, this.keys2);
            } else if ("LOCAL_STRATEGY_HASH_BUILD_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new HashJoinBuildFirstProperties(this.keys1, this.keys2);
            } else if ("LOCAL_STRATEGY_HASH_BUILD_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new HashJoinBuildSecondProperties(this.keys1, this.keys2);
            } else {
                throw new CompilerException("Invalid local strategy hint for match contract: " + localStrategy);
            }
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(fixedDriverStrat);
            return list;
        }
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        list.add(new SortMergeJoinDescriptor(this.keys1, this.keys2));
        list.add(new HashJoinBuildFirstProperties(this.keys1, this.keys2));
        list.add(new HashJoinBuildSecondProperties(this.keys1, this.keys2));
        return list;
    }

    public void makeJoinWithSolutionSet(int solutionsetInputIndex) {
        AbstractJoinDescriptor op;
        if (solutionsetInputIndex == 0) {
            op = new HashJoinBuildFirstProperties(this.keys1, this.keys2);
        } else if (solutionsetInputIndex == 1) {
            op = new HashJoinBuildSecondProperties(this.keys1, this.keys2);
        } else {
            throw new IllegalArgumentException();
        }
        this.possibleProperties.clear();
        this.possibleProperties.add(op);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        long l = this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : Math.max(card1, card2);
        if (this.estimatedNumRecords >= 0L) {
            float width;
            float width1 = this.getFirstPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float width2 = this.getSecondPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float f = width = width1 <= 0.0f || width2 <= 0.0f ? -1.0f : width1 + width2;
            if (width > 0.0f) {
                this.estimatedOutputSize = (long)(width * (float)this.estimatedNumRecords);
            }
        }
    }
}

