/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.SingleInputOperator;
import eu.stratosphere.api.common.operators.base.GroupReduceOperatorBase;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.dag.SingleInputNode;
import eu.stratosphere.compiler.operators.AllGroupReduceProperties;
import eu.stratosphere.compiler.operators.AllGroupWithPartialPreGroupProperties;
import eu.stratosphere.compiler.operators.GroupReduceProperties;
import eu.stratosphere.compiler.operators.GroupReduceWithCombineProperties;
import eu.stratosphere.compiler.operators.OperatorDescriptorSingle;
import eu.stratosphere.configuration.Configuration;
import java.util.Collections;
import java.util.List;

public class GroupReduceNode
extends SingleInputNode {
    private GroupReduceNode combinerUtilityNode;

    public GroupReduceNode(GroupReduceOperatorBase<?, ?, ?> pactContract) {
        super((SingleInputOperator<?, ?, ?>)pactContract);
        if (this.keys == null) {
            this.setDegreeOfParallelism(1);
        }
    }

    public GroupReduceNode(GroupReduceNode reducerToCopyForCombiner) {
        super(reducerToCopyForCombiner);
    }

    public GroupReduceOperatorBase<?, ?, ?> getPactContract() {
        return (GroupReduceOperatorBase)super.getPactContract();
    }

    public boolean isCombineable() {
        return this.getPactContract().isCombinable();
    }

    @Override
    public String getName() {
        return "GroupReduce";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        boolean useCombiner;
        Configuration conf = this.getPactContract().getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            if ("LOCAL_STRATEGY_SORT".equals(localStrategy)) {
                useCombiner = false;
            } else {
                if (!"LOCAL_STRATEGY_COMBINING_SORT".equals(localStrategy)) throw new CompilerException("Invalid local strategy hint for match contract: " + localStrategy);
                if (!this.isCombineable()) {
                    PactCompiler.LOG.warn((Object)("Strategy hint for Reduce Pact '" + this.getPactContract().getName() + "' desires combinable reduce, but user function is not marked combinable."));
                }
                useCombiner = true;
            }
        } else {
            useCombiner = this.isCombineable();
        }
        Ordering groupOrder = null;
        if (this.getPactContract() instanceof GroupReduceOperatorBase && (groupOrder = this.getPactContract().getGroupOrder()) != null && groupOrder.getNumberOfFields() == 0) {
            groupOrder = null;
        }
        OperatorDescriptorSingle operatorDescriptorSingle = useCombiner ? (this.keys == null ? new AllGroupWithPartialPreGroupProperties() : new GroupReduceWithCombineProperties(this.keys, groupOrder)) : (this.keys == null ? new AllGroupReduceProperties() : new GroupReduceProperties(this.keys, groupOrder));
        return Collections.singletonList(operatorDescriptorSingle);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    public GroupReduceNode getCombinerUtilityNode() {
        if (this.combinerUtilityNode == null) {
            this.combinerUtilityNode = new GroupReduceNode(this);
            this.combinerUtilityNode.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
            this.combinerUtilityNode.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        }
        return this.combinerUtilityNode;
    }
}

