/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.costs.CostEstimator;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dataproperties.InterestingProperties;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataSinkNode
extends OptimizerNode {
    protected PactConnection input;

    public DataSinkNode(GenericDataSinkBase<?> sink) {
        super((Operator<?>)sink);
    }

    public PactConnection getInputConnection() {
        return this.input;
    }

    public OptimizerNode getPredecessorNode() {
        if (this.input != null) {
            return this.input.getSource();
        }
        return null;
    }

    public GenericDataSinkBase<?> getPactContract() {
        return (GenericDataSinkBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Data Sink";
    }

    @Override
    public List<PactConnection> getIncomingConnections() {
        return Collections.singletonList(this.input);
    }

    @Override
    public List<PactConnection> getOutgoingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode) {
        PactConnection conn;
        Operator children = this.getPactContract().getInput();
        OptimizerNode pred = contractToNode.get(children);
        this.input = conn = new PactConnection(pred, this);
        pred.addOutgoingConnection(conn);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        this.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties iProps = new InterestingProperties();
        Ordering partitioning = this.getPactContract().getPartitionOrdering();
        DataDistribution dataDist = this.getPactContract().getDataDistribution();
        RequestedGlobalProperties partitioningProps = new RequestedGlobalProperties();
        if (partitioning != null) {
            if (dataDist != null) {
                partitioningProps.setRangePartitioned(partitioning, dataDist);
            } else {
                partitioningProps.setRangePartitioned(partitioning);
            }
            iProps.addGlobalProperties(partitioningProps);
        }
        iProps.addGlobalProperties(partitioningProps);
        Ordering localOrder = this.getPactContract().getLocalOrder();
        RequestedLocalProperties orderProps = new RequestedLocalProperties();
        if (localOrder != null) {
            orderProps.setOrdering(localOrder);
        }
        iProps.addLocalProperties(orderProps);
        this.input.setInterestingProperties(iProps);
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getPredecessorNode().closedBranchingNodes);
        this.openBranches = this.getPredecessorNode().getBranchesForParent(this.input);
    }

    @Override
    protected List<OptimizerNode.UnclosedBranchDescriptor> getBranchesForParent(PactConnection parent) {
        return this.openBranches;
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        int inDop;
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        List<PlanNode> subPlans = this.getPredecessorNode().getAlternativePlans(estimator);
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        int dop = this.getDegreeOfParallelism();
        boolean dopChange = dop != (inDop = this.getPredecessorNode().getDegreeOfParallelism());
        InterestingProperties ips = this.input.getInterestingProperties();
        for (PlanNode p : subPlans) {
            for (RequestedGlobalProperties gp : ips.getGlobalProperties()) {
                for (RequestedLocalProperties lp : ips.getLocalProperties()) {
                    Channel c = new Channel(p);
                    gp.parameterizeChannel(c, dopChange);
                    lp.parameterizeChannel(c);
                    c.setRequiredLocalProps(lp);
                    c.setRequiredGlobalProps(gp);
                    outputPlans.add(new SinkPlanNode(this, "DataSink(" + this.getPactContract().getName() + ")", c));
                }
            }
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return false;
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            if (this.getPredecessorNode() == null) {
                throw new CompilerException();
            }
            this.getPredecessorNode().accept(visitor);
            visitor.postVisit((Visitable)this);
        }
    }
}

