/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.base.CrossOperatorBase;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.operators.CartesianProductDescriptor;
import eu.stratosphere.compiler.operators.CrossBlockOuterFirstDescriptor;
import eu.stratosphere.compiler.operators.CrossBlockOuterSecondDescriptor;
import eu.stratosphere.compiler.operators.CrossStreamOuterFirstDescriptor;
import eu.stratosphere.compiler.operators.CrossStreamOuterSecondDescriptor;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.configuration.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CrossNode
extends TwoInputNode {
    public CrossNode(CrossOperatorBase<?, ?, ?, ?> pactContract) {
        super((DualInputOperator<?, ?, ?, ?>)pactContract);
    }

    public CrossOperatorBase<?, ?, ?, ?> getPactContract() {
        return (CrossOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Cross";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        CrossOperatorBase<?, ?, ?, ?> operation = this.getPactContract();
        boolean allowBCfirst = true;
        boolean allowBCsecond = true;
        if (operation instanceof CrossOperatorBase.CrossWithSmall) {
            allowBCfirst = false;
        } else if (operation instanceof CrossOperatorBase.CrossWithLarge) {
            allowBCsecond = false;
        }
        Configuration conf = operation.getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            CartesianProductDescriptor fixedDriverStrat;
            if ("LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new CrossBlockOuterFirstDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new CrossBlockOuterSecondDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new CrossStreamOuterFirstDescriptor(allowBCfirst, allowBCsecond);
            } else if ("LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new CrossStreamOuterSecondDescriptor(allowBCfirst, allowBCsecond);
            } else {
                throw new CompilerException("Invalid local strategy hint for cross contract: " + localStrategy);
            }
            return Collections.singletonList(fixedDriverStrat);
        }
        if (operation instanceof CrossOperatorBase.CrossWithSmall) {
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(new CrossBlockOuterSecondDescriptor(false, true));
            list.add(new CrossStreamOuterFirstDescriptor(false, true));
            return list;
        }
        if (operation instanceof CrossOperatorBase.CrossWithLarge) {
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(new CrossBlockOuterFirstDescriptor(true, false));
            list.add(new CrossStreamOuterSecondDescriptor(true, false));
            return list;
        }
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        list.add(new CrossBlockOuterFirstDescriptor());
        list.add(new CrossBlockOuterSecondDescriptor());
        list.add(new CrossStreamOuterFirstDescriptor());
        list.add(new CrossStreamOuterSecondDescriptor());
        return list;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        long l = this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : card1 * card2;
        if (this.estimatedNumRecords >= 0L) {
            float width;
            float width1 = this.getFirstPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float width2 = this.getSecondPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float f = width = width1 <= 0.0f || width2 <= 0.0f ? -1.0f : width1 + width2;
            if (width > 0.0f) {
                this.estimatedOutputSize = (long)(width * (float)this.estimatedNumRecords);
            }
        }
    }
}

