/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.base.CoGroupOperatorBase;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.operators.CoGroupDescriptor;
import eu.stratosphere.compiler.operators.CoGroupWithSolutionSetFirstDescriptor;
import eu.stratosphere.compiler.operators.CoGroupWithSolutionSetSecondDescriptor;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import java.util.ArrayList;
import java.util.List;

public class CoGroupNode
extends TwoInputNode {
    public CoGroupNode(CoGroupOperatorBase<?, ?, ?, ?> pactContract) {
        super((DualInputOperator<?, ?, ?, ?>)pactContract);
    }

    public CoGroupOperatorBase<?, ?, ?, ?> getPactContract() {
        return (CoGroupOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "CoGroup";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        Ordering groupOrder1 = null;
        Ordering groupOrder2 = null;
        CoGroupOperatorBase<?, ?, ?, ?> cgc = this.getPactContract();
        groupOrder1 = cgc.getGroupOrderForInputOne();
        groupOrder2 = cgc.getGroupOrderForInputTwo();
        if (groupOrder1 != null && groupOrder1.getNumberOfFields() == 0) {
            groupOrder1 = null;
        }
        if (groupOrder2 != null && groupOrder2.getNumberOfFields() == 0) {
            groupOrder2 = null;
        }
        ArrayList<OperatorDescriptorDual> l = new ArrayList<OperatorDescriptorDual>(1);
        l.add(new CoGroupDescriptor(this.keys1, this.keys2, groupOrder1, groupOrder2));
        return l;
    }

    public void makeCoGroupWithSolutionSet(int solutionsetInputIndex) {
        CoGroupDescriptor op;
        if (solutionsetInputIndex == 0) {
            op = new CoGroupWithSolutionSetFirstDescriptor(this.keys1, this.keys2);
        } else if (solutionsetInputIndex == 1) {
            op = new CoGroupWithSolutionSetSecondDescriptor(this.keys1, this.keys2);
        } else {
            throw new IllegalArgumentException();
        }
        this.possibleProperties.clear();
        this.possibleProperties.add(op);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }
}

