/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.dag;

import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.Union;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.costs.CostEstimator;
import eu.stratosphere.compiler.dag.OptimizerNode;
import eu.stratosphere.compiler.dag.PactConnection;
import eu.stratosphere.compiler.dag.TwoInputNode;
import eu.stratosphere.compiler.dataproperties.GlobalProperties;
import eu.stratosphere.compiler.dataproperties.InterestingProperties;
import eu.stratosphere.compiler.dataproperties.RequestedGlobalProperties;
import eu.stratosphere.compiler.dataproperties.RequestedLocalProperties;
import eu.stratosphere.compiler.operators.BinaryUnionOpDescriptor;
import eu.stratosphere.compiler.operators.OperatorDescriptorDual;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.NamedChannel;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BinaryUnionNode
extends TwoInputNode {
    private Set<RequestedGlobalProperties> channelProps;

    public BinaryUnionNode(Union<?> union) {
        super((DualInputOperator<?, ?, ?, ?>)union);
    }

    @Override
    public String getName() {
        return "Union";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return new ArrayList<OperatorDescriptorDual>();
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : card1 + card2;
        long size1 = this.getFirstPredecessorNode().getEstimatedOutputSize();
        long size2 = this.getSecondPredecessorNode().getEstimatedOutputSize();
        this.estimatedOutputSize = size1 < 0L || size2 < 0L ? -1L : size1 + size2;
    }

    @Override
    public void computeUnionOfInterestingPropertiesFromSuccessors() {
        super.computeUnionOfInterestingPropertiesFromSuccessors();
        this.getInterestingProperties().getLocalProperties().clear();
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties props = this.getInterestingProperties();
        if (props.getGlobalProperties().isEmpty()) {
            props.addGlobalProperties(new RequestedGlobalProperties());
        }
        props.addLocalProperties(new RequestedLocalProperties());
        this.input1.setInterestingProperties(props.clone());
        this.input2.setInterestingProperties(props.clone());
        this.channelProps = props.getGlobalProperties();
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        List<PlanNode> subPlans1 = this.getFirstPredecessorNode().getAlternativePlans(estimator);
        List<PlanNode> subPlans2 = this.getSecondPredecessorNode().getAlternativePlans(estimator);
        ArrayList<Set<? extends NamedChannel>> broadcastPlanChannels = new ArrayList<Set<? extends NamedChannel>>();
        List<PactConnection> broadcastConnections = this.getBroadcastConnections();
        List<String> broadcastConnectionNames = this.getBroadcastConnectionNames();
        for (int i = 0; i < broadcastConnections.size(); ++i) {
            PactConnection broadcastConnection = broadcastConnections.get(i);
            String broadcastConnectionName = broadcastConnectionNames.get(i);
            List<PlanNode> broadcastPlanCandidates = broadcastConnection.getSource().getAlternativePlans(estimator);
            HashSet<NamedChannel> broadcastChannels = new HashSet<NamedChannel>(broadcastPlanCandidates.size());
            for (PlanNode plan : broadcastPlanCandidates) {
                NamedChannel c = new NamedChannel(broadcastConnectionName, plan);
                c.setShipStrategy(ShipStrategyType.BROADCAST);
                broadcastChannels.add(c);
            }
            broadcastPlanChannels.add(broadcastChannels);
        }
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        BinaryUnionOpDescriptor operator = new BinaryUnionOpDescriptor();
        RequestedLocalProperties noLocalProps = new RequestedLocalProperties();
        int dop = this.getDegreeOfParallelism();
        int inDop1 = this.getFirstPredecessorNode().getDegreeOfParallelism();
        int inDop2 = this.getSecondPredecessorNode().getDegreeOfParallelism();
        boolean dopChange1 = dop != inDop1;
        boolean dopChange2 = dop != inDop2;
        for (PlanNode child1 : subPlans1) {
            for (PlanNode child2 : subPlans2) {
                if (!this.areBranchCompatible(child1, child2)) continue;
                for (RequestedGlobalProperties igps : this.channelProps) {
                    Channel c1 = new Channel(child1, this.input1.getMaterializationMode());
                    if (this.input1.getShipStrategy() == null) {
                        igps.parameterizeChannel(c1, dopChange1);
                        if (dopChange1 && !c1.getShipStrategy().isNetworkStrategy()) {
                            c1.getGlobalProperties().reset();
                        }
                    } else {
                        if (this.keys1 != null) {
                            c1.setShipStrategy(this.input1.getShipStrategy(), this.keys1.toFieldList());
                        } else {
                            c1.setShipStrategy(this.input1.getShipStrategy());
                        }
                        if (dopChange1) {
                            c1.adjustGlobalPropertiesForFullParallelismChange();
                        }
                    }
                    Channel c2 = new Channel(child2, this.input2.getMaterializationMode());
                    if (this.input2.getShipStrategy() == null) {
                        igps.parameterizeChannel(c2, dopChange2);
                        if (dopChange2 && !c2.getShipStrategy().isNetworkStrategy()) {
                            c2.getGlobalProperties().reset();
                        }
                    } else {
                        if (this.keys2 != null) {
                            c2.setShipStrategy(this.input2.getShipStrategy(), this.keys2.toFieldList());
                        } else {
                            c2.setShipStrategy(this.input2.getShipStrategy());
                        }
                        if (dopChange2) {
                            c2.adjustGlobalPropertiesForFullParallelismChange();
                        }
                    }
                    GlobalProperties p1 = c1.getGlobalProperties();
                    GlobalProperties p2 = c2.getGlobalProperties();
                    p1.clearUniqueFieldCombinations();
                    p2.clearUniqueFieldCombinations();
                    if (!igps.isTrivial() && !p1.equals(p2)) {
                        if (c1.getShipStrategy() == ShipStrategyType.FORWARD && c2.getShipStrategy() != ShipStrategyType.FORWARD) {
                            c2 = c2.clone();
                            p1.parameterizeChannel(c2, dopChange2);
                        } else if (c2.getShipStrategy() == ShipStrategyType.FORWARD && c1.getShipStrategy() != ShipStrategyType.FORWARD) {
                            c1 = c1.clone();
                            p2.parameterizeChannel(c1, dopChange1);
                        } else if (c1.getShipStrategy() == ShipStrategyType.FORWARD && c2.getShipStrategy() == ShipStrategyType.FORWARD) {
                            boolean adjustC1;
                            boolean bl = adjustC1 = c1.getEstimatedOutputSize() <= 0L || c2.getEstimatedOutputSize() <= 0L || c1.getEstimatedOutputSize() <= c2.getEstimatedOutputSize();
                            if (adjustC1) {
                                c2 = c2.clone();
                                p1.parameterizeChannel(c2, dopChange2);
                            } else {
                                c1 = c1.clone();
                                p2.parameterizeChannel(c1, dopChange1);
                            }
                        } else {
                            throw new CompilerException("Bug in Plan Enumeration for Union Node.");
                        }
                    }
                    this.instantiate(operator, c1, c2, broadcastPlanChannels, outputPlans, estimator, igps, igps, noLocalProps, noLocalProps);
                }
            }
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        outputPlans.trimToSize();
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return true;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        OptimizerNode in1 = this.getFirstPredecessorNode();
        OptimizerNode in2 = this.getSecondPredecessorNode();
        this.estimatedNumRecords = in1.estimatedNumRecords > 0L && in2.estimatedNumRecords > 0L ? in1.estimatedNumRecords + in2.estimatedNumRecords : -1L;
        this.estimatedOutputSize = in1.estimatedOutputSize > 0L && in2.estimatedOutputSize > 0L ? in1.estimatedOutputSize + in2.estimatedOutputSize : -1L;
    }
}

