/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.compiler.contextcheck;

import com.google.common.base.Preconditions;
import eu.stratosphere.api.common.InvalidProgramException;
import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.DualInputOperator;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.SingleInputOperator;
import eu.stratosphere.api.common.operators.base.BulkIterationBase;
import eu.stratosphere.api.common.operators.base.FileDataSinkBase;
import eu.stratosphere.api.common.operators.base.FileDataSourceBase;
import eu.stratosphere.api.common.operators.base.GenericDataSinkBase;
import eu.stratosphere.compiler.contextcheck.MissingChildException;
import eu.stratosphere.compiler.contextcheck.Validatable;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.util.Visitor;
import java.util.HashSet;
import java.util.Set;

public class ContextChecker
implements Visitor<Operator<?>> {
    private final Set<Operator<?>> visitedNodes = new HashSet();

    public void check(Plan plan) {
        Preconditions.checkNotNull((Object)plan, (Object)"The passed plan is null.");
        this.visitedNodes.clear();
        plan.accept((Visitor)this);
    }

    public boolean preVisit(Operator<?> node) {
        if (!this.visitedNodes.add(node)) {
            return false;
        }
        if (node instanceof FileDataSinkBase) {
            this.checkFileDataSink((FileDataSinkBase)node);
        } else if (node instanceof FileDataSourceBase) {
            this.checkFileDataSource((FileDataSourceBase)node);
        } else if (node instanceof GenericDataSinkBase) {
            this.checkDataSink((GenericDataSinkBase)node);
        } else if (node instanceof BulkIterationBase) {
            this.checkBulkIteration((BulkIterationBase)node);
        } else if (node instanceof SingleInputOperator) {
            this.checkSingleInputContract((SingleInputOperator)node);
        } else if (node instanceof DualInputOperator) {
            this.checkDualInputContract((DualInputOperator)node);
        }
        if (node instanceof Validatable) {
            ((Validatable)node).check();
        }
        return true;
    }

    public void postVisit(Operator<?> node) {
    }

    private void checkDataSink(GenericDataSinkBase<?> dataSinkContract) {
        Operator input = dataSinkContract.getInput();
        if (input == null) {
            throw new MissingChildException();
        }
    }

    private void checkFileDataSink(FileDataSinkBase<?> fileSink) {
        String path = fileSink.getFilePath();
        if (path == null) {
            throw new InvalidProgramException("File path of FileDataSink is null.");
        }
        if (path.length() == 0) {
            throw new InvalidProgramException("File path of FileDataSink is empty string.");
        }
        try {
            Path p = new Path(path);
            String scheme = p.toUri().getScheme();
            if (scheme == null) {
                throw new InvalidProgramException("File path \"" + path + "\" of FileDataSink has no file system scheme (like 'file:// or hdfs://').");
            }
        }
        catch (Exception e) {
            throw new InvalidProgramException("File path \"" + path + "\" of FileDataSink is an invalid path: " + e.getMessage());
        }
        this.checkDataSink((GenericDataSinkBase<?>)fileSink);
    }

    private void checkFileDataSource(FileDataSourceBase<?> fileSource) {
        String path = fileSource.getFilePath();
        if (path == null) {
            throw new InvalidProgramException("File path of FileDataSource is null.");
        }
        if (path.length() == 0) {
            throw new InvalidProgramException("File path of FileDataSource is empty string.");
        }
        try {
            Path p = new Path(path);
            String scheme = p.toUri().getScheme();
            if (scheme == null) {
                throw new InvalidProgramException("File path \"" + path + "\" of FileDataSource has no file system scheme (like 'file:// or hdfs://').");
            }
        }
        catch (Exception e) {
            throw new InvalidProgramException("File path \"" + path + "\" of FileDataSource is an invalid path: " + e.getMessage());
        }
    }

    private void checkSingleInputContract(SingleInputOperator<?, ?, ?> singleInputContract) {
        Operator input = singleInputContract.getInput();
        if (input == null) {
            throw new MissingChildException();
        }
    }

    private void checkDualInputContract(DualInputOperator<?, ?, ?, ?> dualInputContract) {
        Operator input1 = dualInputContract.getFirstInput();
        Operator input2 = dualInputContract.getSecondInput();
        if (input1 == null || input2 == null) {
            throw new MissingChildException();
        }
    }

    private void checkBulkIteration(BulkIterationBase<?> iter) {
        iter.validate();
        this.checkSingleInputContract((SingleInputOperator<?, ?, ?>)iter);
    }
}

