/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.web;

import eu.stratosphere.client.web.JobSubmissionServlet;
import eu.stratosphere.client.web.JobsInfoServlet;
import eu.stratosphere.client.web.JobsServlet;
import eu.stratosphere.client.web.PactJobJSONServlet;
import eu.stratosphere.client.web.PlanDisplayServlet;
import eu.stratosphere.configuration.ConfigConstants;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebInterfaceServer {
    private static final Log LOG = LogFactory.getLog(WebInterfaceServer.class);
    private final Server server;

    public WebInterfaceServer(Configuration nepheleConfig, int port) throws IOException {
        Configuration config = GlobalConfiguration.getConfiguration();
        if (nepheleConfig == null) {
            nepheleConfig = config;
        }
        String basePath = nepheleConfig.getString("stratosphere.base.dir.path", "");
        String webDirPath = config.getString("webclient.rootpath", "./resources/web-docs/");
        File webDir = webDirPath.startsWith("/") ? new File(webDirPath) : new File(basePath + "/" + webDirPath);
        String tmpDirPath = config.getString("webclient.tempdir", ConfigConstants.DEFAULT_WEB_TMP_DIR);
        File tmpDir = new File(tmpDirPath);
        if (!tmpDir.isAbsolute()) {
            tmpDir = new File(basePath + "/" + tmpDirPath);
        }
        String uploadDirPath = config.getString("webclient.uploaddir", ConfigConstants.DEFAULT_WEB_JOB_STORAGE_DIR);
        File uploadDir = new File(uploadDirPath);
        if (!uploadDir.isAbsolute()) {
            uploadDir = new File(basePath + "/" + uploadDirPath);
        }
        String planDumpDirPath = config.getString("webclient.plandump", ConfigConstants.DEFAULT_WEB_PLAN_DUMP_DIR);
        File planDumpDir = new File(planDumpDirPath);
        if (!planDumpDir.isAbsolute()) {
            planDumpDir = new File(basePath + "/" + planDumpDirPath);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Setting up web frontend server, using web-root directory '" + webDir.getAbsolutePath() + "'."));
            LOG.info((Object)("Web frontend server will store temporary files in '" + tmpDir.getAbsolutePath() + "', uploaded jobs in '" + uploadDir.getAbsolutePath() + "', plan-json-dumps in '" + planDumpDir.getAbsolutePath() + "'."));
            LOG.info((Object)("Web-frontend will submit jobs to nephele job-manager on " + config.getString("jobmanager.rpc.address", null) + ", port " + config.getInteger("jobmanager.rpc.port", 6123) + "."));
        }
        this.server = new Server(port);
        if (!webDir.exists()) {
            throw new FileNotFoundException("The directory containing the web documents does not exist: " + webDir.getAbsolutePath());
        }
        this.checkAndCreateDirectories(tmpDir, true);
        this.checkAndCreateDirectories(uploadDir, true);
        this.checkAndCreateDirectories(planDumpDir, true);
        int jobManagerWebPort = config.getInteger("jobmanager.web.port", 8081);
        ServletContextHandler servletContext = new ServletContextHandler(1);
        servletContext.setContextPath("/");
        servletContext.addServlet(new ServletHolder((Servlet)new PactJobJSONServlet(uploadDir)), "/pactPlan");
        servletContext.addServlet(new ServletHolder((Servlet)new JobsInfoServlet(nepheleConfig)), "/jobsInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new PlanDisplayServlet(jobManagerWebPort)), "/showPlan");
        servletContext.addServlet(new ServletHolder((Servlet)new JobsServlet(uploadDir, tmpDir, "launch.html")), "/jobs");
        servletContext.addServlet(new ServletHolder((Servlet)new JobSubmissionServlet(nepheleConfig, uploadDir, planDumpDir)), "/runJob");
        ResourceHandler pactPlanHandler = new ResourceHandler();
        pactPlanHandler.setDirectoriesListed(false);
        pactPlanHandler.setResourceBase(planDumpDir.getAbsolutePath());
        ContextHandler pactPlanContext = new ContextHandler();
        pactPlanContext.setContextPath("/ajax-plans");
        pactPlanContext.setHandler((Handler)pactPlanHandler);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setResourceBase(webDir.getAbsolutePath());
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContext);
        handlers.addHandler((Handler)pactPlanContext);
        handlers.addHandler((Handler)resourceHandler);
        File af = null;
        String authFile = config.getString("webclient.access", ConfigConstants.DEFAULT_WEB_ACCESS_FILE_PATH);
        if (authFile != null && !(af = new File(authFile)).exists()) {
            LOG.error((Object)("The specified file '" + af.getAbsolutePath() + "' with the authentication information is missing. Starting server without HTTP authentication."));
            af = null;
        }
        if (af != null) {
            HashLoginService loginService = new HashLoginService("Stratosphere Query Engine Interface", authFile);
            this.server.addBean((Object)loginService);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"user"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            sh.addConstraintMapping(mapping);
            sh.setAuthenticator((Authenticator)new BasicAuthenticator());
            sh.setLoginService((LoginService)loginService);
            sh.setStrict(true);
            sh.setHandler((Handler)handlers);
            this.server.setHandler((Handler)sh);
        } else {
            this.server.setHandler((Handler)handlers);
        }
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    private final void checkAndCreateDirectories(File f, boolean needWritePermission) throws IOException {
        String dir = f.getAbsolutePath();
        if (f.exists() && !f.isDirectory()) {
            throw new IOException("A none directory file with the same name as the configured directory '" + dir + "' already exists.");
        }
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Could not create the directory '" + dir + "'.");
        }
        if (!f.canRead() || !f.canExecute()) {
            throw new IOException("The directory '" + dir + "' cannot be read and listed.");
        }
        if (needWritePermission && !f.canWrite()) {
            throw new IOException("No write access could be obtained on directory '" + dir + "'.");
        }
    }
}

