/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.web;

import eu.stratosphere.client.web.GUIServletStub;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PlanDisplayServlet
extends GUIServletStub {
    private static final long serialVersionUID = 3610115341264927614L;
    private final int runtimeVisualizationPort;
    private String runtimeVisURL;

    public PlanDisplayServlet(int runtimePort) {
        super("Stratosphere Query Interface - Query Plan");
        this.runtimeVisualizationPort = runtimePort;
        this.addStyleSheet("css/nephelefrontend.css");
        this.addStyleSheet("css/pactgraphs.css");
        this.addStyleSheet("css/graph.css");
        this.addStyleSheet("css/overlay.css");
        this.addStyleSheet("css/bootstrap.css");
        this.addJavascriptFile("js/jquery-2.1.0.js");
        this.addJavascriptFile("js/graphCreator.js");
        this.addJavascriptFile("js/d3.js");
        this.addJavascriptFile("js/dagre-d3.js");
        this.addJavascriptFile("js/bootstrap.min.js");
        this.addJavascriptFile("js/jquery.tools.min.js");
    }

    @Override
    public void printPage(PrintWriter writer, Map<String, String[]> parameters, HttpServletRequest req) throws IOException {
        String suspend;
        String[] x = parameters.get("id");
        String uid = x != null && x.length >= 1 ? x[0] : null;
        x = parameters.get("suspended");
        String string = suspend = x != null && x.length >= 1 ? x[0] : null;
        if (uid == null || suspend == null) {
            writer.println("    <div class=\"error_text\" style=\"margin-top: 50px; font-size: 18px;\">");
            writer.println("      <p>Parameters identifying the plan and the suspension strategy are missing.</p>");
            writer.println("    </div>");
            return;
        }
        if (this.runtimeVisURL == null) {
            try {
                URI request = new URI(req.getRequestURL().toString());
                URI vizURI = new URI(request.getScheme(), null, request.getHost(), this.runtimeVisualizationPort, null, null, null);
                this.runtimeVisURL = vizURI.toString();
                System.out.println(this.runtimeVisURL);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        boolean suspended = Boolean.parseBoolean(suspend);
        writer.println("    <div style=\"position: relative;\">\n      <div id=\"mainCanvas\" class=\"canvas boxed\">\n      <div id=\"attach\"><svg id=\"svg-main\" width=500 height=500><g transform=\"translate(20, 20)\"/></svg></div>      </div>\n      <div style=\"position: absolute; right: 20px; bottom: 20px;\">\n        <input id=\"back_button\" type=\"button\" value=\"&lt; Back\"/>");
        if (suspended) {
            writer.println("        <input id=\"run_button\" type=\"button\" value=\"Continue &gt;\"/>");
        }
        writer.println("      </div>\n    </div>");
        writer.println("    <div class=\"simple_overlay\" id=\"propertyO\"><div id=\"propertyCanvas\" class=\"propertyCanvas\"></div>\n    </div>");
        writer.println("    <script type=\"text/javascript\">\n    <!--\n      var maxColumnWidth = 350;\n      var minColumnWidth = 150;\n\n      $(document).ready(function() {\n");
        writer.println("        // register the event handler for the 'run' button\n        $('#run_button').click(function () {\n          $('#run_button').remove();\n          $.ajax( { url: '/runJob', data: { action: 'runsubmitted', id: '" + uid + "' }," + " success: function () { alert('Job succesfully submitted');" + (this.runtimeVisURL != null ? " window.location = \"" + this.runtimeVisURL + "\"; }," : " },") + " error: function (xhr, ajaxOptions, thrownError) { alert(xhr.responseText); }" + "          });\n" + "        });\n");
        writer.println("        // register the event handler for the 'back' button\n        $('#back_button').click(function () {\n" + (suspended ? "          var url = \"/runJob?\" + $.param({action: \"back\", id: \"" + uid + "\" });\n" : "          var url = \"launch.html\";\n") + "          window.location = url;\n" + "        });\n");
        writer.println("        //change height of mainCanvas to maximum        $(\"#mainCanvas\").css(\"height\", $(document).height() - 15 - 105);\n        // use jquery to asynchronously load the pact plan description\n        $.getJSON(\"ajax-plans/" + uid + ".json\", function(data) { drawGraph(data, \"#svg-main\"); });" + "      });\n" + "    //-->\n" + "    </script>");
    }
}

