/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.web;

import eu.stratosphere.client.program.PackagedProgram;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PactJobJSONServlet
extends HttpServlet {
    private static final long serialVersionUID = 558077298726449201L;
    private static final Log LOG = LogFactory.getLog(PactJobJSONServlet.class);
    private static final String JOB_PARAM_NAME = "job";
    private final File jobStoreDirectory;

    public PactJobJSONServlet(File jobStoreDirectory) {
        this.jobStoreDirectory = jobStoreDirectory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PackagedProgram pactProgram;
        resp.setContentType("application/json");
        String jobName = req.getParameter(JOB_PARAM_NAME);
        if (jobName == null) {
            LOG.warn((Object)"Received request without job parameter name.");
            resp.setStatus(400);
            return;
        }
        File jarFile = new File(this.jobStoreDirectory, jobName);
        if (!jarFile.exists()) {
            LOG.warn((Object)"Received request for non-existing jar file.");
            resp.setStatus(400);
            return;
        }
        try {
            pactProgram = new PackagedProgram(jarFile, new String[0]);
        }
        catch (Throwable t) {
            LOG.info((Object)("Instantiating the PactProgram for '" + jarFile.getName() + "' failed."), t);
            resp.setStatus(400);
            resp.getWriter().print(t.getMessage());
            return;
        }
        String jsonPlan = null;
        String programDescription = null;
        try {
            jsonPlan = pactProgram.getPreviewPlan();
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to create json dump of pact program.", t);
        }
        try {
            programDescription = pactProgram.getDescription();
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to create description of pact program.", t);
        }
        if (jsonPlan == null && programDescription == null) {
            resp.setStatus(400);
            return;
        }
        resp.setStatus(200);
        PrintWriter wrt = resp.getWriter();
        wrt.print("{ \"jobname\": \"");
        wrt.print(jobName);
        if (jsonPlan != null) {
            wrt.print("\", \"plan\": ");
            wrt.println(jsonPlan);
        }
        if (programDescription != null) {
            wrt.print(", \"description\": \"");
            wrt.print(this.escapeString(programDescription));
            wrt.print("\"");
        }
        wrt.println("}");
    }

    protected String escapeString(String str) {
        int len = str.length();
        char[] s = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = s[i];
            if (c == '\\' || c == '\"' || c == '/') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c < ' ') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

