/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.web;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.protocols.VersionedProtocol;
import eu.stratosphere.nephele.event.job.RecentJobEvent;
import eu.stratosphere.nephele.ipc.RPC;
import eu.stratosphere.nephele.net.NetUtils;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JobsInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 558077298726449201L;
    private final Configuration config;

    public JobsInfoServlet(Configuration nepheleConfig) {
        this.config = nepheleConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ExtendedManagementProtocol jmConn = null;
        try {
            jmConn = this.getJMConnection();
            List recentJobs = jmConn.getRecentJobs();
            ArrayList jobs = new ArrayList(recentJobs);
            resp.setStatus(200);
            PrintWriter wrt = resp.getWriter();
            wrt.write("[");
            for (int i = 0; i < jobs.size(); ++i) {
                RecentJobEvent jobEvent = (RecentJobEvent)jobs.get(i);
                wrt.write("{");
                wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
                if (jobEvent.getJobName() != null) {
                    wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
                }
                wrt.write("\"status\": \"" + jobEvent.getJobStatus() + "\",");
                wrt.write("\"time\": " + jobEvent.getTimestamp());
                wrt.write("}");
                if (i == jobs.size() - 1) continue;
                wrt.write(",");
            }
            wrt.write("]");
        }
        catch (Throwable t) {
            resp.setStatus(400);
            resp.getWriter().print(t.getMessage());
        }
        finally {
            if (jmConn != null) {
                try {
                    RPC.stopProxy((VersionedProtocol)jmConn);
                }
                catch (Throwable t) {
                    System.err.println("Could not cleanly shut down connection from compiler to job manager");
                }
            }
            jmConn = null;
        }
    }

    private ExtendedManagementProtocol getJMConnection() throws IOException {
        String jmHost = this.config.getString("jobmanager.rpc.address", null);
        String jmPort = this.config.getString("jobmanager.rpc.port", null);
        return (ExtendedManagementProtocol)RPC.getProxy(ExtendedManagementProtocol.class, (InetSocketAddress)new InetSocketAddress(jmHost, Integer.parseInt(jmPort)), (SocketFactory)NetUtils.getSocketFactory());
    }

    protected String escapeString(String str) {
        int len = str.length();
        char[] s = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = s[i];
            if (c == '\\' || c == '\"' || c == '/') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c < ' ') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

