/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.web;

import eu.stratosphere.client.program.Client;
import eu.stratosphere.client.program.PackagedProgram;
import eu.stratosphere.client.program.ProgramInvocationException;
import eu.stratosphere.compiler.CompilerException;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSubmissionServlet
extends HttpServlet {
    private static final long serialVersionUID = 8447312301029847397L;
    public static final String START_PAGE_URL = "launch.html";
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_SUBMIT_VALUE = "submit";
    private static final String ACTION_RUN_SUBMITTED_VALUE = "runsubmitted";
    private static final String ACTION_BACK_VALUE = "back";
    private static final String JOB_PARAM_NAME = "job";
    private static final String ARGUMENTS_PARAM_NAME = "arguments";
    private static final String SHOW_PLAN_PARAM_NAME = "show_plan";
    private static final String SUSPEND_PARAM_NAME = "suspend";
    private static final Log LOG = LogFactory.getLog(JobSubmissionServlet.class);
    private final File jobStoreDirectory;
    private final File planDumpDirectory;
    private final Map<Long, JobGraph> submittedJobs;
    private final Random rand;
    private final Client client;

    public JobSubmissionServlet(Configuration nepheleConfig, File jobDir, File planDir) {
        this.client = new Client(nepheleConfig);
        this.jobStoreDirectory = jobDir;
        this.planDumpDirectory = planDir;
        this.submittedJobs = Collections.synchronizedMap(new HashMap());
        this.rand = new Random(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter(ACTION_PARAM_NAME);
        if (this.checkParameterSet(resp, action, ACTION_PARAM_NAME)) {
            return;
        }
        if (action.equals(ACTION_SUBMIT_VALUE)) {
            OptimizedPlan optPlan;
            PackagedProgram program;
            String jobName = req.getParameter(JOB_PARAM_NAME);
            String args = req.getParameter(ARGUMENTS_PARAM_NAME);
            String showPlan = req.getParameter(SHOW_PLAN_PARAM_NAME);
            String suspendPlan = req.getParameter(SUSPEND_PARAM_NAME);
            if (this.checkParameterSet(resp, jobName, JOB_PARAM_NAME) || this.checkParameterSet(resp, args, ARGUMENTS_PARAM_NAME) || this.checkParameterSet(resp, showPlan, SHOW_PLAN_PARAM_NAME) || this.checkParameterSet(resp, suspendPlan, SUSPEND_PARAM_NAME)) {
                this.showErrorPage(resp, "Invalid request, missing parameters.");
                return;
            }
            boolean show = Boolean.parseBoolean(showPlan);
            boolean suspend = Boolean.parseBoolean(suspendPlan);
            File jarFile = new File(this.jobStoreDirectory, jobName);
            if (!jarFile.exists()) {
                this.showErrorPage(resp, "The jar file + '" + jarFile.getPath() + "' does not exist.");
                return;
            }
            List<String> params = null;
            try {
                params = JobSubmissionServlet.tokenizeArguments(args);
            }
            catch (IllegalArgumentException iaex) {
                this.showErrorPage(resp, "The arguments contain an unterminated quoted string.");
                return;
            }
            String assemblerClass = null;
            if (params.size() >= 2 && params.get(0).equals("assembler")) {
                assemblerClass = params.get(1);
                params.remove(0);
                params.remove(0);
            }
            String[] options = params.isEmpty() ? new String[]{} : params.toArray(new String[params.size()]);
            try {
                program = assemblerClass == null ? new PackagedProgram(jarFile, options) : new PackagedProgram(jarFile, assemblerClass, options);
                optPlan = this.client.getOptimizedPlan(program, -1);
                if (optPlan == null) {
                    throw new Exception("The optimized plan could not be produced.");
                }
            }
            catch (ProgramInvocationException e) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                if (e.getCause() == null) {
                    e.printStackTrace(w);
                } else {
                    e.getCause().printStackTrace(w);
                }
                this.showErrorPage(resp, "An error occurred while invoking the program:<br/><br/>" + e.getMessage() + "<br/>" + "<br/><br/><pre>" + sw.toString() + "</pre>");
                return;
            }
            catch (CompilerException cex) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                cex.printStackTrace(w);
                this.showErrorPage(resp, "An error occurred in the compiler:<br/><br/>" + cex.getMessage() + "<br/>" + (cex.getCause() != null ? "Caused by: " + cex.getCause().getMessage() : "") + "<br/><br/><pre>" + sw.toString() + "</pre>");
                return;
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                t.printStackTrace(w);
                this.showErrorPage(resp, "An unexpected error occurred:<br/><br/>" + t.getMessage() + "<br/><br/><pre>" + sw.toString() + "</pre>");
                return;
            }
            if (show) {
                Long uid = null;
                while (this.submittedJobs.containsKey(uid = Long.valueOf(Math.abs(this.rand.nextLong())))) {
                }
                String planName = uid + ".json";
                File jsonFile = new File(this.planDumpDirectory, planName);
                new PlanJSONDumpGenerator().dumpOptimizerPlanAsJSON(optPlan, jsonFile);
                if (!suspend) {
                    try {
                        this.client.run(program, optPlan, false);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"Error submitting job to the job-manager.", t);
                        this.showErrorPage(resp, t.getMessage());
                        return;
                    }
                    finally {
                        program.deleteExtractedLibraries();
                    }
                }
                try {
                    this.submittedJobs.put(uid, this.client.getJobGraph(program, optPlan));
                }
                catch (ProgramInvocationException piex) {
                    LOG.error((Object)"Error creating JobGraph from optimized plan.", (Throwable)piex);
                    this.showErrorPage(resp, piex.getMessage());
                    return;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error creating JobGraph from optimized plan.", t);
                    this.showErrorPage(resp, t.getMessage());
                    return;
                }
                resp.sendRedirect("showPlan?id=" + uid + "&suspended=" + (suspend ? "true" : "false"));
            } else {
                try {
                    this.client.run(program, -1, false);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error submitting job to the job-manager.", (Throwable)ex);
                    String errorMessage = ex.getMessage().split("\n")[0];
                    this.showErrorPage(resp, errorMessage);
                    return;
                }
                finally {
                    program.deleteExtractedLibraries();
                }
                resp.sendRedirect(START_PAGE_URL);
            }
        } else if (action.equals(ACTION_RUN_SUBMITTED_VALUE)) {
            String id = req.getParameter("id");
            if (this.checkParameterSet(resp, id, "id")) {
                return;
            }
            Long uid = null;
            try {
                uid = Long.parseLong(id);
            }
            catch (NumberFormatException nfex) {
                this.showErrorPage(resp, "An invalid id for the job was provided.");
                return;
            }
            JobGraph job = this.submittedJobs.remove(uid);
            if (job == null) {
                resp.sendError(400, "No job with the given uid was retained for later submission.");
                return;
            }
            try {
                this.client.run(job, false);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error submitting job to the job-manager.", (Throwable)ex);
                resp.setStatus(400);
                String errorMessage = ex.getMessage().split("\n")[0];
                resp.getWriter().print(errorMessage);
                return;
            }
            resp.sendRedirect(START_PAGE_URL);
        } else if (action.equals(ACTION_BACK_VALUE)) {
            String id = req.getParameter("id");
            if (this.checkParameterSet(resp, id, "id")) {
                return;
            }
            Long uid = null;
            try {
                uid = Long.parseLong(id);
            }
            catch (NumberFormatException nfex) {
                this.showErrorPage(resp, "An invalid id for the job was provided.");
                return;
            }
            this.submittedJobs.remove(uid);
            resp.sendRedirect(START_PAGE_URL);
        } else {
            this.showErrorPage(resp, "Invalid action specified.");
            return;
        }
    }

    private void showErrorPage(HttpServletResponse resp, String message) throws IOException {
        resp.setStatus(200);
        resp.setContentType("text/html;charset=utf-8");
        PrintWriter writer = resp.getWriter();
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("  <title>Launch Job - Error</title>");
        writer.println("  <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\" />");
        writer.println("  <link rel=\"stylesheet\" type=\"text/css\" href=\"css/nephelefrontend.css\" />");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("  <div class=\"mainHeading\">");
        writer.println("    <h1><img src=\"img/StratosphereLogo.png\" width=\"326\" height=\"100\" alt=\"Stratosphere Logo\" align=\"middle\"/>Nephele and PACTs Query Interface</h1>");
        writer.println("  </div>");
        writer.println("  <div style=\"margin-top: 50px; text-align: center;\">");
        writer.println("    <p class=\"error_text\" style=\"font-size: 18px;\">");
        writer.println(message);
        writer.println("    </p><br/><br/>");
        writer.println("    <form action=\"launch.html\" method=\"GET\">");
        writer.println("      <input type=\"submit\" value=\"back\">");
        writer.println("    </form>");
        writer.println("  </div>");
        writer.println("</body>");
        writer.println("</html>");
    }

    private boolean checkParameterSet(HttpServletResponse resp, String parameter, String parameterName) throws IOException {
        if (parameter == null) {
            this.showErrorPage(resp, "The parameter '" + parameterName + "' is not set.");
            return true;
        }
        return false;
    }

    private static final List<String> tokenizeArguments(String args) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder curr = new StringBuilder();
        boolean quoted = false;
        for (int pos = 0; pos < args.length(); ++pos) {
            char c = args.charAt(pos);
            if (!(c != ' ' && c != '\t' || quoted)) {
                if (curr.length() <= 0) continue;
                list.add(curr.toString());
                curr.setLength(0);
                continue;
            }
            if (c == '\"') {
                quoted = !quoted;
                continue;
            }
            curr.append(c);
        }
        if (quoted) {
            throw new IllegalArgumentException("Unterminated quoted string.");
        }
        if (curr.length() > 0) {
            list.add(curr.toString());
        }
        return list;
    }
}

