/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.program;

import eu.stratosphere.api.common.JobExecutionResult;
import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.operators.translation.JavaPlan;
import eu.stratosphere.client.program.Client;
import eu.stratosphere.client.program.JobWithJars;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import java.io.File;
import java.util.List;

public class ContextEnvironment
extends ExecutionEnvironment {
    private final Client client;
    private final List<File> jarFilesToAttach;
    private final ClassLoader userCodeClassLoader;

    public ContextEnvironment(Client remoteConnection, List<File> jarFiles, ClassLoader userCodeClassLoader) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars((Plan)p, this.jarFilesToAttach, this.userCodeClassLoader);
        return this.client.run(toRun, this.getDegreeOfParallelism(), true);
    }

    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan("unnamed job");
        OptimizedPlan op = this.client.getOptimizedPlan((Plan)p, this.getDegreeOfParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public String toString() {
        return "Context Environment (DOP = " + (this.getDegreeOfParallelism() == -1 ? "default" : Integer.valueOf(this.getDegreeOfParallelism())) + ") : " + this.getIdString();
    }

    public void setAsContext() {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironment)this);
    }

    public static void disableLocalExecution() {
        ExecutionEnvironment.disableLocalExecution();
    }
}

