/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client.minicluster;

import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.nephele.ExecutionMode;
import eu.stratosphere.nephele.client.JobClient;
import eu.stratosphere.nephele.instance.HardwareDescriptionFactory;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.nephele.jobmanager.JobManager;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NepheleMiniCluster {
    private static final Log LOG = LogFactory.getLog(NepheleMiniCluster.class);
    private static final int DEFAULT_JM_RPC_PORT = 6498;
    private static final int DEFAULT_TM_RPC_PORT = 6501;
    private static final int DEFAULT_TM_DATA_PORT = 7501;
    private static final long DEFAULT_MEMORY_SIZE = -1L;
    private static final int DEFAULT_NUM_TASK_MANAGER = 1;
    private static final boolean DEFAULT_LAZY_MEMORY_ALLOCATION = true;
    private static final int DEFAULT_TASK_MANAGER_NUM_SLOTS = -1;
    private final Object startStopLock = new Object();
    private int jobManagerRpcPort = 6498;
    private int taskManagerRpcPort = 6501;
    private int taskManagerDataPort = 7501;
    private int numTaskTracker = 1;
    private int taskManagerNumSlots = -1;
    private long memorySize = -1L;
    private String configDir;
    private String hdfsConfigFile;
    private boolean lazyMemoryAllocation = true;
    private boolean defaultOverwriteFiles = false;
    private boolean defaultAlwaysCreateDirectory = false;
    private JobManager jobManager;

    public int getJobManagerRpcPort() {
        return this.jobManagerRpcPort;
    }

    public void setJobManagerRpcPort(int jobManagerRpcPort) {
        this.jobManagerRpcPort = jobManagerRpcPort;
    }

    public int getTaskManagerRpcPort() {
        return this.taskManagerRpcPort;
    }

    public void setTaskManagerRpcPort(int taskManagerRpcPort) {
        this.taskManagerRpcPort = taskManagerRpcPort;
    }

    public int getTaskManagerDataPort() {
        return this.taskManagerDataPort;
    }

    public void setTaskManagerDataPort(int taskManagerDataPort) {
        this.taskManagerDataPort = taskManagerDataPort;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(long memorySize) {
        this.memorySize = memorySize;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public String getHdfsConfigFile() {
        return this.hdfsConfigFile;
    }

    public void setHdfsConfigFile(String hdfsConfigFile) {
        this.hdfsConfigFile = hdfsConfigFile;
    }

    public boolean isLazyMemoryAllocation() {
        return this.lazyMemoryAllocation;
    }

    public void setLazyMemoryAllocation(boolean lazyMemoryAllocation) {
        this.lazyMemoryAllocation = lazyMemoryAllocation;
    }

    public boolean isDefaultOverwriteFiles() {
        return this.defaultOverwriteFiles;
    }

    public void setDefaultOverwriteFiles(boolean defaultOverwriteFiles) {
        this.defaultOverwriteFiles = defaultOverwriteFiles;
    }

    public boolean isDefaultAlwaysCreateDirectory() {
        return this.defaultAlwaysCreateDirectory;
    }

    public void setDefaultAlwaysCreateDirectory(boolean defaultAlwaysCreateDirectory) {
        this.defaultAlwaysCreateDirectory = defaultAlwaysCreateDirectory;
    }

    public void setNumTaskTracker(int numTaskTracker) {
        this.numTaskTracker = numTaskTracker;
    }

    public int getNumTaskTracker() {
        return this.numTaskTracker;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    public JobClient getJobClient(JobGraph jobGraph) throws Exception {
        Configuration configuration = jobGraph.getJobConfiguration();
        configuration.setString("jobmanager.rpc.address", "localhost");
        configuration.setInteger("jobmanager.rpc.port", this.jobManagerRpcPort);
        return new JobClient(jobGraph, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.configDir != null) {
                GlobalConfiguration.loadConfiguration((String)this.configDir);
            } else {
                Configuration conf = NepheleMiniCluster.getMiniclusterDefaultConfig(this.jobManagerRpcPort, this.taskManagerRpcPort, this.taskManagerDataPort, this.memorySize, this.hdfsConfigFile, this.lazyMemoryAllocation, this.defaultOverwriteFiles, this.defaultAlwaysCreateDirectory, this.taskManagerNumSlots, this.numTaskTracker);
                GlobalConfiguration.includeConfiguration((Configuration)conf);
            }
            NepheleMiniCluster.initializeIOFormatClasses();
            Thread[] allThreads = new Thread[Thread.activeCount()];
            int numThreads = Thread.enumerate(allThreads);
            for (int i = 0; i < numThreads; ++i) {
                Thread t = allThreads[i];
                String name = t.getName();
                if (!name.startsWith("IPC")) continue;
                t.join();
            }
            this.jobManager = new JobManager(ExecutionMode.LOCAL);
            this.waitForJobManagerToBecomeReady(this.numTaskTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.jobManager != null) {
                this.jobManager.shutdown();
                this.jobManager = null;
            }
        }
    }

    private void waitForJobManagerToBecomeReady(int numTaskManagers) throws InterruptedException {
        while (this.jobManager.getNumberOfTaskTrackers() < numTaskManagers) {
            Thread.sleep(50L);
        }
    }

    private static void initializeIOFormatClasses() {
        try {
            Method im = FileInputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", new Class[0]);
            im.setAccessible(true);
            im.invoke(null, new Object[0]);
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", new Class[0]);
            om.setAccessible(true);
            om.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot (re) initialize the globally loaded defaults. Some classes might mot follow the specified default behavior.");
        }
    }

    public static Configuration getMiniclusterDefaultConfig(int jobManagerRpcPort, int taskManagerRpcPort, int taskManagerDataPort, long memorySize, String hdfsConfigFile, boolean lazyMemory, boolean defaultOverwriteFiles, boolean defaultAlwaysCreateDirectory, int taskManagerNumSlots, int numTaskManager) {
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", "localhost");
        config.setInteger("jobmanager.rpc.port", jobManagerRpcPort);
        config.setInteger("taskmanager.rpc.port", taskManagerRpcPort);
        config.setInteger("taskmanager.data.port", taskManagerDataPort);
        config.setInteger("jobmanager.rpc.numhandler", 2);
        config.setBoolean("taskmanager.memory.lazyalloc", lazyMemory);
        config.setInteger("jobclient.polling.interval", 2);
        if (hdfsConfigFile != null) {
            config.setString("fs.hdfs.hdfsdefault", hdfsConfigFile);
        }
        config.setBoolean("fs.overwrite-files", defaultOverwriteFiles);
        config.setBoolean("fs.output.always-create-directory", defaultAlwaysCreateDirectory);
        if (memorySize < 0L) {
            memorySize = HardwareDescriptionFactory.extractFromSystem().getSizeOfFreeMemory();
            long bufferMem = GlobalConfiguration.getLong((String)"taskmanager.network.numberOfBuffers", (long)2048L) * GlobalConfiguration.getLong((String)"taskmanager.network.bufferSizeInBytes", (long)32768L);
            memorySize -= bufferMem * (long)numTaskManager;
            memorySize = (long)((float)memorySize * 0.7f);
            memorySize >>>= 20;
        }
        config.setLong("taskmanager.memory.size", memorySize /= (long)numTaskManager);
        config.setInteger("localinstancemanager.numtaskmanager", numTaskManager);
        config.setInteger("taskmanager.numberOfTaskSlots", taskManagerNumSlots);
        return config;
    }
}

