/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client;

import eu.stratosphere.client.web.WebInterfaceServer;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebFrontend {
    private static final Log LOG = LogFactory.getLog(WebFrontend.class);

    public static void main(String[] args) {
        try {
            String configDir = null;
            if (args.length >= 2 && args[0].equals("-configDir")) {
                configDir = args[1];
            }
            if (configDir == null) {
                System.err.println("Error: Configuration directory must be specified.\nWebFrontend -configDir <directory>\n");
                System.exit(1);
                return;
            }
            GlobalConfiguration.loadConfiguration(configDir);
            Configuration config = GlobalConfiguration.getConfiguration();
            config.setString("stratosphere.base.dir.path", configDir + "/..");
            int port = config.getInteger("webclient.port", 8080);
            WebInterfaceServer server = new WebInterfaceServer(config, port);
            LOG.info((Object)("Starting web frontend server on port " + port + '.'));
            server.start();
            server.join();
        }
        catch (Throwable t) {
            LOG.error((Object)("Unexpected exception: " + t.getMessage()), t);
        }
    }
}

