/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client;

import eu.stratosphere.api.common.InvalidProgramException;
import eu.stratosphere.api.common.JobExecutionResult;
import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.PlanExecutor;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.client.minicluster.NepheleMiniCluster;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.contextcheck.ContextChecker;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.nephele.client.JobClient;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.util.LogUtils;
import java.util.List;
import org.apache.log4j.Level;

public class LocalExecutor
extends PlanExecutor {
    private static boolean DEFAULT_OVERWRITE = false;
    private static final int DEFAULT_TASK_MANAGER_NUM_SLOTS = -1;
    private final Object lock = new Object();
    private NepheleMiniCluster nephele;
    private int jobManagerRpcPort = -1;
    private int taskManagerRpcPort = -1;
    private int taskManagerDataPort = -1;
    private int taskManagerNumSlots = -1;
    private String configDir;
    private String hdfsConfigFile;
    private boolean defaultOverwriteFiles = DEFAULT_OVERWRITE;
    private boolean defaultAlwaysCreateDirectory = false;

    public LocalExecutor() {
        if (!ExecutionEnvironment.localExecutionIsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be used when submitting a program through a client.");
        }
        if (System.getProperty("log4j.configuration") == null) {
            LocalExecutor.setLoggingLevel(Level.INFO);
        }
    }

    public int getJobManagerRpcPort() {
        return this.jobManagerRpcPort;
    }

    public void setJobManagerRpcPort(int jobManagerRpcPort) {
        this.jobManagerRpcPort = jobManagerRpcPort;
    }

    public int getTaskManagerRpcPort() {
        return this.taskManagerRpcPort;
    }

    public void setTaskManagerRpcPort(int taskManagerRpcPort) {
        this.taskManagerRpcPort = taskManagerRpcPort;
    }

    public int getTaskManagerDataPort() {
        return this.taskManagerDataPort;
    }

    public void setTaskManagerDataPort(int taskManagerDataPort) {
        this.taskManagerDataPort = taskManagerDataPort;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public String getHdfsConfig() {
        return this.hdfsConfigFile;
    }

    public void setHdfsConfig(String hdfsConfig) {
        this.hdfsConfigFile = hdfsConfig;
    }

    public boolean isDefaultOverwriteFiles() {
        return this.defaultOverwriteFiles;
    }

    public void setDefaultOverwriteFiles(boolean defaultOverwriteFiles) {
        this.defaultOverwriteFiles = defaultOverwriteFiles;
    }

    public boolean isDefaultAlwaysCreateDirectory() {
        return this.defaultAlwaysCreateDirectory;
    }

    public void setDefaultAlwaysCreateDirectory(boolean defaultAlwaysCreateDirectory) {
        this.defaultAlwaysCreateDirectory = defaultAlwaysCreateDirectory;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.nephele == null) {
                this.nephele = new NepheleMiniCluster();
                if (this.jobManagerRpcPort > 0) {
                    this.nephele.setJobManagerRpcPort(this.jobManagerRpcPort);
                }
                if (this.taskManagerRpcPort > 0) {
                    this.nephele.setTaskManagerRpcPort(this.jobManagerRpcPort);
                }
                if (this.taskManagerDataPort > 0) {
                    this.nephele.setTaskManagerDataPort(this.taskManagerDataPort);
                }
                if (this.configDir != null) {
                    this.nephele.setConfigDir(this.configDir);
                }
                if (this.hdfsConfigFile != null) {
                    this.nephele.setHdfsConfigFile(this.hdfsConfigFile);
                }
            } else {
                throw new IllegalStateException("The local executor was already started.");
            }
            this.nephele.setDefaultOverwriteFiles(this.defaultOverwriteFiles);
            this.nephele.setDefaultAlwaysCreateDirectory(this.defaultAlwaysCreateDirectory);
            this.nephele.setTaskManagerNumSlots(this.taskManagerNumSlots);
            this.nephele.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.nephele == null) {
                throw new IllegalStateException("The local executor was not started.");
            }
            this.nephele.stop();
            this.nephele = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutionResult executePlan(Plan plan) throws Exception {
        if (plan == null) {
            throw new IllegalArgumentException("The plan may not be null.");
        }
        ContextChecker checker = new ContextChecker();
        checker.check(plan);
        Object object = this.lock;
        synchronized (object) {
            JobExecutionResult jobExecutionResult;
            block11: {
                boolean shutDownAtEnd;
                if (this.nephele == null) {
                    int maxParallelism;
                    shutDownAtEnd = true;
                    if (this.taskManagerNumSlots == -1 && (maxParallelism = plan.getMaximumParallelism()) > 0) {
                        this.taskManagerNumSlots = maxParallelism;
                    }
                    this.start();
                } else {
                    shutDownAtEnd = false;
                }
                try {
                    JobExecutionResult result;
                    PactCompiler pc = new PactCompiler(new DataStatistics());
                    OptimizedPlan op = pc.compile(plan);
                    NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
                    JobGraph jobGraph = jgg.compileJobGraph(op);
                    JobClient jobClient = this.nephele.getJobClient(jobGraph);
                    jobExecutionResult = result = jobClient.submitJobAndWait();
                    if (!shutDownAtEnd) break block11;
                }
                catch (Throwable throwable) {
                    if (shutDownAtEnd) {
                        this.stop();
                    }
                    throw throwable;
                }
                this.stop();
            }
            return jobExecutionResult;
        }
    }

    public String getOptimizerPlanAsJSON(Plan plan) throws Exception {
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(plan);
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public static JobExecutionResult execute(Program pa, String ... args) throws Exception {
        return LocalExecutor.execute(pa.getPlan(args));
    }

    public static JobExecutionResult execute(Plan plan) throws Exception {
        LocalExecutor exec = new LocalExecutor();
        try {
            exec.start();
            JobExecutionResult jobExecutionResult = exec.executePlan(plan);
            return jobExecutionResult;
        }
        finally {
            exec.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String optimizerPlanAsJSON(Plan plan) throws Exception {
        LocalExecutor exec = new LocalExecutor();
        try {
            exec.start();
            PactCompiler pc = new PactCompiler(new DataStatistics());
            OptimizedPlan op = pc.compile(plan);
            PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
            String string = gen.getOptimizerPlanAsJSON(op);
            return string;
        }
        finally {
            exec.stop();
        }
    }

    public static String getPlanAsJSON(Plan plan) {
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        List sinks = PactCompiler.createPreOptimizedPlan((Plan)plan);
        return gen.getPactPlanAsJSON(sinks);
    }

    public static void setLoggingLevel(Level lvl) {
        LogUtils.initializeDefaultConsoleLogger((Level)lvl);
    }

    public static void setOverwriteFilesByDefault(boolean overwriteByDefault) {
        DEFAULT_OVERWRITE = overwriteByDefault;
    }
}

