/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.client;

import eu.stratosphere.api.common.JobExecutionResult;
import eu.stratosphere.api.common.accumulators.AccumulatorHelper;
import eu.stratosphere.client.RemoteExecutor;
import eu.stratosphere.client.program.Client;
import eu.stratosphere.client.program.PackagedProgram;
import eu.stratosphere.client.program.ProgramInvocationException;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.core.protocols.VersionedProtocol;
import eu.stratosphere.nephele.event.job.RecentJobEvent;
import eu.stratosphere.nephele.ipc.RPC;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobgraph.JobStatus;
import eu.stratosphere.nephele.net.NetUtils;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import eu.stratosphere.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.io.FileUtils;

public class CliFrontend {
    private static final String ACTION_RUN = "run";
    private static final String ACTION_INFO = "info";
    private static final String ACTION_LIST = "list";
    private static final String ACTION_CANCEL = "cancel";
    private static final Option HELP_OPTION = new Option("h", "help", false, "Show the help for the CLI Frontend.");
    private static final Option VERBOSE_OPTION = new Option("v", "verbose", false, "Print more detailed error messages.");
    private static final Option JAR_OPTION = new Option("j", "jarfile", true, "Stratosphere program JAR file.");
    private static final Option CLASS_OPTION = new Option("c", "class", true, "Class with the program entry point (\"main\" method or \"getPlan()\" method. Only needed if the JAR file does not specify the class in its manifest.");
    private static final Option PARALLELISM_OPTION = new Option("p", "parallelism", true, "The parallelism with which to run the program. Optional flag to override the default value specified in the configuration.");
    private static final Option ARGS_OPTION = new Option("a", "arguments", true, "Program arguments. Arguments can also be added without -a, simply as trailing parameters.");
    private static final Option ADDRESS_OPTION = new Option("m", "jobmanager", true, "Address of the JobManager (master) to which to connect. Use this flag to connect to a different JobManager than the one specified in the configuration.");
    private static final Option DESCR_OPTION = new Option("d", "description", false, "Show description of expected program arguments");
    private static final Option PLAN_OPTION = new Option("e", "executionplan", false, "Show optimized execution plan of the program (JSON)");
    private static final Option RUNNING_OPTION = new Option("r", "running", false, "Show running programs and their JobIDs");
    private static final Option SCHEDULED_OPTION = new Option("s", "scheduled", false, "Show scheduled prorgrams and their JobIDs");
    private static final Option ID_OPTION = new Option("i", "jobid", true, "JobID of program to cancel");
    private static final Options GENRAL_OPTIONS;
    private static final Options RUN_OPTIONS;
    private static final Options INFO_OPTIONS;
    private static final Options LIST_OPTIONS;
    private static final Options CANCEL_OPTIONS;
    private static final String ENV_CONFIG_DIRECTORY = "STRATOSPHERE_CONF_DIR";
    private static final String CONFIG_DIRECTORY_FALLBACK_1 = "../conf";
    private static final String CONFIG_DIRECTORY_FALLBACK_2 = "conf";
    public static final String JOBMANAGER_ADDRESS_FILE = ".yarn-jobmanager";
    private CommandLineParser parser = new PosixParser();
    private boolean verbose;
    private boolean printHelp;
    private boolean globalConfigurationLoaded;

    private static void initOptions() {
        HELP_OPTION.setRequired(false);
        VERBOSE_OPTION.setRequired(false);
        JAR_OPTION.setRequired(false);
        JAR_OPTION.setArgName("jarfile");
        CLASS_OPTION.setRequired(false);
        CLASS_OPTION.setArgName("classname");
        ADDRESS_OPTION.setRequired(false);
        ADDRESS_OPTION.setArgName("host:port");
        PARALLELISM_OPTION.setRequired(false);
        PARALLELISM_OPTION.setArgName("parallelism");
        ARGS_OPTION.setRequired(false);
        ARGS_OPTION.setArgName("programArgs");
        ARGS_OPTION.setArgs(-2);
        PLAN_OPTION.setRequired(false);
        DESCR_OPTION.setRequired(false);
        RUNNING_OPTION.setRequired(false);
        SCHEDULED_OPTION.setRequired(false);
        ID_OPTION.setRequired(false);
        ID_OPTION.setArgName("jobID");
    }

    static Options createGeneralOptions() {
        Options options = new Options();
        options.addOption(HELP_OPTION);
        options.addOption(VERBOSE_OPTION);
        return options;
    }

    static Options getProgramSpecificOptions(Options options) {
        options.addOption(JAR_OPTION);
        options.addOption(CLASS_OPTION);
        options.addOption(PARALLELISM_OPTION);
        options.addOption(ARGS_OPTION);
        return options;
    }

    static Options getProgramSpecificOptionsWithoutDeprecatedOptions(Options options) {
        options.addOption(CLASS_OPTION);
        options.addOption(PARALLELISM_OPTION);
        return options;
    }

    static Options getRunOptions(Options options) {
        Options o = CliFrontend.getProgramSpecificOptions(options);
        return CliFrontend.getJobManagerAddressOption(o);
    }

    static Options getRunOptionsWithoutDeprecatedOptions(Options options) {
        Options o = CliFrontend.getProgramSpecificOptionsWithoutDeprecatedOptions(options);
        return CliFrontend.getJobManagerAddressOption(o);
    }

    static Options getJobManagerAddressOption(Options options) {
        options.addOption(ADDRESS_OPTION);
        return options;
    }

    static Options getInfoOptions(Options options) {
        options = CliFrontend.getProgramSpecificOptions(options);
        options = CliFrontend.getJobManagerAddressOption(options);
        options.addOption(DESCR_OPTION);
        options.addOption(PLAN_OPTION);
        return options;
    }

    static Options getInfoOptionsWithoutDeprecatedOptions(Options options) {
        options = CliFrontend.getProgramSpecificOptionsWithoutDeprecatedOptions(options);
        options = CliFrontend.getJobManagerAddressOption(options);
        options.addOption(DESCR_OPTION);
        options.addOption(PLAN_OPTION);
        return options;
    }

    static Options getListOptions(Options options) {
        options.addOption(RUNNING_OPTION);
        options.addOption(SCHEDULED_OPTION);
        options = CliFrontend.getJobManagerAddressOption(options);
        return options;
    }

    static Options getCancelOptions(Options options) {
        options.addOption(ID_OPTION);
        options = CliFrontend.getJobManagerAddressOption(options);
        return options;
    }

    protected int run(String[] args) {
        CommandLine line;
        try {
            line = this.parser.parse(RUN_OPTIONS, args, false);
            this.evaluateGeneralOptions(line);
        }
        catch (MissingOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForRun();
            return 1;
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForRun();
            return 2;
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        if (this.printHelp) {
            this.printHelpForRun();
            return 0;
        }
        try {
            PackagedProgram program = this.buildProgram(line);
            if (program == null) {
                this.printHelpForRun();
                return 1;
            }
            Client client = this.getClient(line);
            if (client == null) {
                this.printHelpForRun();
                return 1;
            }
            int parallelism = -1;
            if (line.hasOption(PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(PARALLELISM_OPTION.getOpt());
                try {
                    parallelism = Integer.parseInt(parString);
                }
                catch (NumberFormatException e) {
                    System.out.println("The value " + parString + " is invalid for the degree of parallelism.");
                    this.printHelpForRun();
                    return 1;
                }
                if (parallelism <= 0) {
                    System.out.println("Invalid value for the degree-of-parallelism. Parallelism must be greater than zero.");
                    this.printHelpForRun();
                    return 1;
                }
            }
            return this.executeProgram(program, client, parallelism);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeProgram(PackagedProgram program, Client client, int parallelism) {
        JobExecutionResult execResult;
        try {
            client.setPrintStatusDuringExecution(true);
            execResult = client.run(program, parallelism, true);
        }
        catch (ProgramInvocationException e) {
            int n = this.handleError(e);
            return n;
        }
        finally {
            program.deleteExtractedLibraries();
        }
        if (execResult != null) {
            System.out.println("Job Runtime: " + execResult.getNetRuntime());
            Map accumulatorsResult = execResult.getAllAccumulatorResults();
            if (accumulatorsResult.size() > 0) {
                System.out.println("Accumulator Results: ");
                System.out.println(AccumulatorHelper.getResultsFormated((Map)accumulatorsResult));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int info(String[] args) {
        PackagedProgram program;
        CommandLine line;
        try {
            line = this.parser.parse(INFO_OPTIONS, args, false);
            this.evaluateGeneralOptions(line);
        }
        catch (MissingOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForInfo();
            return 1;
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForInfo();
            return 2;
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        if (this.printHelp) {
            this.printHelpForInfo();
            return 0;
        }
        boolean description = line.hasOption(DESCR_OPTION.getOpt());
        boolean plan = line.hasOption(PLAN_OPTION.getOpt());
        if (!description && !plan) {
            System.out.println("ERROR: Specify the information to display.");
            this.printHelpForInfo();
            return 1;
        }
        try {
            program = this.buildProgram(line);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (program == null) {
            this.printHelpForInfo();
            return 1;
        }
        int parallelism = -1;
        if (line.hasOption(PARALLELISM_OPTION.getOpt())) {
            String parString = line.getOptionValue(PARALLELISM_OPTION.getOpt());
            try {
                parallelism = Integer.parseInt(parString);
            }
            catch (NumberFormatException e) {
                System.out.println("The value " + parString + " is invalid for the degree of parallelism.");
                this.printHelpForRun();
                return 1;
            }
            if (parallelism <= 0) {
                System.out.println("Invalid value for the degree-of-parallelism. Parallelism must be greater than zero.");
                this.printHelpForRun();
                return 1;
            }
        }
        try {
            if (description) {
                String descr = program.getDescription();
                if (descr != null) {
                    System.out.println("-------------------- Program Description ---------------------");
                    System.out.println(descr);
                    System.out.println("--------------------------------------------------------------");
                } else {
                    System.out.println("No description available for this program.");
                }
            }
            if (plan) {
                Client client = this.getClient(line);
                String jsonPlan = client.getOptimizedPlanAsJson(program, parallelism);
                if (jsonPlan != null) {
                    System.out.println("----------------------- Execution Plan -----------------------");
                    System.out.println(jsonPlan);
                    System.out.println("--------------------------------------------------------------");
                } else {
                    System.out.println("JSON plan could not be compiled.");
                }
            }
            int client = 0;
            return client;
        }
        catch (Throwable t) {
            int n = this.handleError(t);
            return n;
        }
        finally {
            program.deleteExtractedLibraries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int list(String[] args) {
        CommandLine line;
        try {
            line = this.parser.parse(LIST_OPTIONS, args, false);
        }
        catch (MissingOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForList();
            return 1;
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForList();
            return 2;
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        if (this.printHelp) {
            this.printHelpForList();
            return 0;
        }
        boolean running = line.hasOption(RUNNING_OPTION.getOpt());
        boolean scheduled = line.hasOption(SCHEDULED_OPTION.getOpt());
        if (!running && !scheduled) {
            System.out.println("Error: Specify the status of the jobs to list.");
            this.printHelpForList();
            return 1;
        }
        ExtendedManagementProtocol jmConn = null;
        try {
            jmConn = this.getJobManagerConnection(line);
            if (jmConn == null) {
                this.printHelpForList();
                int n = 1;
                return n;
            }
            List recentJobs = jmConn.getRecentJobs();
            ArrayList<RecentJobEvent> runningJobs = null;
            ArrayList<RecentJobEvent> scheduledJobs = null;
            if (running) {
                runningJobs = new ArrayList<RecentJobEvent>();
            }
            if (scheduled) {
                scheduledJobs = new ArrayList<RecentJobEvent>();
            }
            for (RecentJobEvent rje : recentJobs) {
                if (running && rje.getJobStatus().equals((Object)JobStatus.RUNNING)) {
                    runningJobs.add(rje);
                }
                if (!scheduled || !rje.getJobStatus().equals((Object)JobStatus.SCHEDULED)) continue;
                scheduledJobs.add(rje);
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Comparator<RecentJobEvent> njec = new Comparator<RecentJobEvent>(){

                @Override
                public int compare(RecentJobEvent o1, RecentJobEvent o2) {
                    return (int)(o1.getTimestamp() - o2.getTimestamp());
                }
            };
            if (running) {
                if (runningJobs.size() == 0) {
                    System.out.println("No running jobs.");
                } else {
                    Collections.sort(runningJobs, njec);
                    System.out.println("------------------------ Running Jobs ------------------------");
                    for (RecentJobEvent je : runningJobs) {
                        System.out.println(df.format(new Date(je.getTimestamp())) + " : " + je.getJobID().toString() + " : " + je.getJobName());
                    }
                    System.out.println("--------------------------------------------------------------");
                }
            }
            if (scheduled) {
                if (scheduledJobs.size() == 0) {
                    System.out.println("No scheduled jobs.");
                } else {
                    Collections.sort(scheduledJobs, njec);
                    System.out.println("----------------------- Scheduled Jobs -----------------------");
                    for (RecentJobEvent je : scheduledJobs) {
                        System.out.println(df.format(new Date(je.getTimestamp())) + " : " + je.getJobID().toString() + " : " + je.getJobName());
                    }
                    System.out.println("--------------------------------------------------------------");
                }
            }
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            int n = this.handleError(t);
            return n;
        }
        finally {
            if (jmConn != null) {
                try {
                    RPC.stopProxy((VersionedProtocol)jmConn);
                }
                catch (Throwable t) {
                    System.out.println("Could not cleanly shut down connection from compiler to job manager");
                }
            }
            jmConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int cancel(String[] args) {
        JobID jobId;
        CommandLine line;
        try {
            line = this.parser.parse(CANCEL_OPTIONS, args, false);
        }
        catch (MissingOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForCancel();
            return 1;
        }
        catch (UnrecognizedOptionException e) {
            System.out.println(e.getMessage());
            this.printHelpForCancel();
            return 2;
        }
        catch (Exception e) {
            return this.handleError(e);
        }
        if (this.printHelp) {
            this.printHelpForCancel();
            return 0;
        }
        if (line.hasOption(ID_OPTION.getOpt())) {
            String jobIdString = line.getOptionValue(ID_OPTION.getOpt());
            try {
                jobId = new JobID(StringUtils.hexStringToByte((String)jobIdString));
            }
            catch (Exception e) {
                System.out.println("Error: The value for the Job ID is not a valid ID.");
                this.printHelpForCancel();
                return 1;
            }
        } else {
            System.out.println("Error: Specify a Job ID to cancel a job.");
            this.printHelpForCancel();
            return 1;
        }
        ExtendedManagementProtocol jmConn = null;
        try {
            jmConn = this.getJobManagerConnection(line);
            if (jmConn == null) {
                this.printHelpForCancel();
                int e = 1;
                return e;
            }
            jmConn.cancelJob(jobId);
            int e = 0;
            return e;
        }
        catch (Throwable t) {
            int n = this.handleError(t);
            return n;
        }
        finally {
            if (jmConn != null) {
                try {
                    RPC.stopProxy((VersionedProtocol)jmConn);
                }
                catch (Throwable t) {
                    System.out.println("Warning: Could not cleanly shut down connection to the JobManager.");
                }
            }
            jmConn = null;
        }
    }

    protected PackagedProgram buildProgram(CommandLine line) {
        String[] programArgs = line.hasOption(ARGS_OPTION.getOpt()) ? line.getOptionValues(ARGS_OPTION.getOpt()) : line.getArgs();
        String jarFilePath = null;
        if (line.hasOption(JAR_OPTION.getOpt())) {
            jarFilePath = line.getOptionValue(JAR_OPTION.getOpt());
        } else if (programArgs.length > 0) {
            jarFilePath = programArgs[0];
            programArgs = Arrays.copyOfRange(programArgs, 1, programArgs.length);
        } else {
            System.out.println("Error: Jar file is not set.");
            return null;
        }
        File jarFile = new File(jarFilePath);
        if (!jarFile.exists()) {
            System.out.println("Error: Jar file does not exist.");
            return null;
        }
        if (!jarFile.isFile()) {
            System.out.println("Error: Jar file is not a file.");
            return null;
        }
        String entryPointClass = line.hasOption(CLASS_OPTION.getOpt()) ? line.getOptionValue(CLASS_OPTION.getOpt()) : null;
        try {
            return entryPointClass == null ? new PackagedProgram(jarFile, programArgs) : new PackagedProgram(jarFile, entryPointClass, programArgs);
        }
        catch (ProgramInvocationException e) {
            this.handleError(e);
            return null;
        }
    }

    protected InetSocketAddress getJobManagerAddress(CommandLine line) throws IOException {
        int jobManagerPort;
        Configuration configuration = this.getGlobalConfiguration();
        if (line.hasOption(ADDRESS_OPTION.getOpt())) {
            try {
                String address = line.getOptionValue(ADDRESS_OPTION.getOpt());
                return RemoteExecutor.getInetFromHostport(address);
            }
            catch (Exception e) {
                System.out.println("Error: The JobManager address has an invalid format. " + e.getMessage());
                return null;
            }
        }
        String loc = this.getConfigurationDirectory();
        File jmAddressFile = new File(loc + '/' + JOBMANAGER_ADDRESS_FILE);
        if (jmAddressFile.exists()) {
            try {
                String address = FileUtils.readFileToString((File)jmAddressFile).trim();
                System.out.println("Found a .yarn-jobmanager file, using \"" + address + "\" to connect to the JobManager");
                return RemoteExecutor.getInetFromHostport(address);
            }
            catch (Exception e) {
                System.out.println("Found a .yarn-jobmanager file, but could not read the JobManager address from the file. " + e.getMessage());
                return null;
            }
        }
        String jobManagerAddress = configuration.getString("jobmanager.rpc.address", null);
        if (jobManagerAddress == null) {
            System.out.println("Error: Found no configuration in the config directory '" + this.getConfigurationDirectory() + "' that specifies the JobManager address.");
            return null;
        }
        try {
            jobManagerPort = configuration.getInteger("jobmanager.rpc.port", -1);
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid value for the JobManager IPC port (jobmanager.rpc.port) in the configuration.");
            return null;
        }
        if (jobManagerPort == -1) {
            System.out.println("Error: Found no configuration in the config directory '" + this.getConfigurationDirectory() + "' that specifies the JobManager port.");
            return null;
        }
        return new InetSocketAddress(jobManagerAddress, jobManagerPort);
    }

    protected ExtendedManagementProtocol getJobManagerConnection(CommandLine line) throws IOException {
        InetSocketAddress jobManagerAddress = this.getJobManagerAddress(line);
        if (jobManagerAddress == null) {
            return null;
        }
        String address = jobManagerAddress.getAddress().getHostAddress();
        int port = jobManagerAddress.getPort();
        return (ExtendedManagementProtocol)RPC.getProxy(ExtendedManagementProtocol.class, (InetSocketAddress)new InetSocketAddress(address, port), (SocketFactory)NetUtils.getSocketFactory());
    }

    protected String getConfigurationDirectory() {
        String location = null;
        if (System.getenv(ENV_CONFIG_DIRECTORY) != null) {
            location = System.getenv(ENV_CONFIG_DIRECTORY);
        } else if (new File(CONFIG_DIRECTORY_FALLBACK_1).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_1;
        } else if (new File(CONFIG_DIRECTORY_FALLBACK_2).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_2;
        } else {
            throw new RuntimeException("The configuration directory was not found. Please configure the 'STRATOSPHERE_CONF_DIR' environment variable properly.");
        }
        return location;
    }

    protected Configuration getGlobalConfiguration() {
        if (!this.globalConfigurationLoaded) {
            String location = this.getConfigurationDirectory();
            GlobalConfiguration.loadConfiguration((String)location);
            this.globalConfigurationLoaded = true;
        }
        return GlobalConfiguration.getConfiguration();
    }

    protected Client getClient(CommandLine line) throws IOException {
        return new Client(this.getJobManagerAddress(line), this.getGlobalConfiguration());
    }

    private void printHelp() {
        System.out.println("./stratosphere <ACTION> [GENERAL_OPTIONS] [ARGUMENTS]");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.setLeftPadding(5);
        formatter.setSyntaxPrefix("  general options:");
        formatter.printHelp(" ", GENRAL_OPTIONS);
        this.printHelpForRun();
        this.printHelpForInfo();
        this.printHelpForList();
        this.printHelpForCancel();
    }

    private void printHelpForRun() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        System.out.println("\nAction \"run\" compiles and runs a program.");
        System.out.println("\n  Syntax: run [OPTIONS] <jar-file> <arguments>");
        formatter.setSyntaxPrefix("  \"run\" action arguments:");
        formatter.printHelp(" ", CliFrontend.getRunOptionsWithoutDeprecatedOptions(new Options()));
    }

    private void printHelpForInfo() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        System.out.println("\nAction \"info\" displays information about a program.");
        formatter.setSyntaxPrefix("  \"info\" action arguments:");
        formatter.printHelp(" ", CliFrontend.getInfoOptionsWithoutDeprecatedOptions(new Options()));
    }

    private void printHelpForList() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        System.out.println("\nAction \"list\" lists running and finished programs.");
        formatter.setSyntaxPrefix("  \"list\" action arguments:");
        formatter.printHelp(" ", CliFrontend.getListOptions(new Options()));
    }

    private void printHelpForCancel() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        System.out.println("\nAction \"cancel\" cancels a running program.");
        formatter.setSyntaxPrefix("  \"cancel\" action arguments:");
        formatter.printHelp(" ", CliFrontend.getCancelOptions(new Options()));
    }

    private int handleError(Throwable t) {
        System.out.println("Error: " + t.getMessage());
        if (this.verbose) {
            t.printStackTrace();
        } else {
            System.out.println("For a more detailed error message use the vebose output option '-v'.");
        }
        return 1;
    }

    private void evaluateGeneralOptions(CommandLine line) {
        this.printHelp = line.hasOption(HELP_OPTION.getOpt());
        this.verbose = line.hasOption(VERBOSE_OPTION.getOpt());
    }

    public int parseParameters(String[] args) {
        if (args.length < 1) {
            System.out.println("Please specify an action.");
            this.printHelp();
            return 1;
        }
        String action = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        if (action.equals(ACTION_RUN)) {
            return this.run(params);
        }
        if (action.equals(ACTION_LIST)) {
            return this.list(params);
        }
        if (action.equals(ACTION_INFO)) {
            return this.info(params);
        }
        if (action.equals(ACTION_CANCEL)) {
            return this.cancel(params);
        }
        if (action.equals("-h") || action.equals("--help")) {
            this.printHelp();
            return 0;
        }
        System.out.println("Invalid action!");
        this.printHelp();
        return 1;
    }

    public static void main(String[] args) throws ParseException {
        CliFrontend cli = new CliFrontend();
        int retCode = cli.parseParameters(args);
        System.exit(retCode);
    }

    static {
        CliFrontend.initOptions();
        GENRAL_OPTIONS = CliFrontend.createGeneralOptions();
        RUN_OPTIONS = CliFrontend.getRunOptions(CliFrontend.createGeneralOptions());
        INFO_OPTIONS = CliFrontend.getInfoOptions(CliFrontend.createGeneralOptions());
        LIST_OPTIONS = CliFrontend.getListOptions(CliFrontend.createGeneralOptions());
        CANCEL_OPTIONS = CliFrontend.getCancelOptions(CliFrontend.createGeneralOptions());
    }
}

