/*
 * Decompiled with CFR 0.152.
 */
package rs.mojo.uploadfiles;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class Upload
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.distributionManagementArtifactRepository}")
    private ArtifactRepository repository;
    @Component(role=WagonManager.class)
    private WagonManager wagonManager;
    @Parameter(alias="path", required=false)
    private File path;
    @Parameter(alias="targetPath", required=false)
    private String targetPath;
    @Parameter(property="rs.upload.chmod", defaultValue="true")
    private boolean chmod;
    @Parameter(property="rs.upload.chmod.mode", defaultValue="g+w,a+rX")
    private String chmodMode;
    @Parameter(property="rs.upload.chmod.options", defaultValue="-Rf")
    private String chmodOptions;
    @Parameter(property="rs.upload.skip", defaultValue="false")
    private boolean skipDeploy;
    @Parameter
    private List<String> preCommands;
    @Parameter(property="rs.upload.failOnPreCommandErrors", defaultValue="false")
    private boolean failOnPreCommandErrors;
    @Parameter
    private List<String> postCommands;
    @Parameter(property="rs.upload.failOnPostCommandErrors", defaultValue="false")
    private boolean failOnPostCommandErrors;
    @Component
    private Settings settings;
    @Component
    protected MavenSession mavenSession;
    @Component
    private PlexusContainer container;
    private Map<String, String> replacements;

    public void execute() throws MojoExecutionException {
        this.deploy(this.getPath(), new Repository(this.repository.getId(), Upload.appendSlash(this.repository.getUrl())));
    }

    private File getPath() {
        if (this.path != null) {
            return this.path;
        }
        return this.project.getArtifact().getFile();
    }

    protected static String appendSlash(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    protected String getTargetPath() {
        String rc = null;
        File path = this.getPath();
        rc = this.targetPath != null ? this.targetPath : "";
        if (rc.endsWith("/") || rc.length() == 0) {
            rc = rc + path.getName();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploy(File file, Repository repository) throws MojoExecutionException {
        Wagon wagon = this.getWagon(repository, this.wagonManager);
        try {
            Upload.configureWagon(wagon, repository.getId(), this.settings, this.container, this.getLog());
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        AuthenticationInfo authenticationInfo = this.authenticationInfo(this.repository);
        this.getLog().debug((CharSequence)("authenticationInfo with id '" + repository.getId() + "': " + (authenticationInfo == null ? "-" : authenticationInfo.getUserName())));
        ProxyInfo proxyInfo = this.proxyInfo(this.repository);
        this.getLog().debug((CharSequence)("proxyInfo with id '" + repository.getId() + "': " + (proxyInfo == null ? "-" : proxyInfo.getUserName())));
        this.createReplacements(repository, authenticationInfo);
        try {
            this.push(file, repository, wagon, authenticationInfo, proxyInfo, this.getTargetPath());
            if (this.chmod) {
                Upload.chmod(wagon, repository, this.chmodOptions, this.chmodMode);
            }
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    private AuthenticationInfo authenticationInfo(ArtifactRepository repository) {
        Authentication auth = repository.getAuthentication();
        AuthenticationInfo ai = null;
        if (auth != null) {
            ai = new AuthenticationInfo();
            ai.setUserName(auth.getUsername());
            ai.setPassword(auth.getPassword());
            ai.setPassphrase(auth.getPassphrase());
            ai.setPrivateKey(auth.getPrivateKey());
        }
        return ai;
    }

    private ProxyInfo proxyInfo(ArtifactRepository repository) {
        Proxy proxy = repository.getProxy();
        ProxyInfo pi = null;
        if (proxy != null) {
            pi = new ProxyInfo();
            pi.setHost(proxy.getHost());
            pi.setPort(proxy.getPort());
            pi.setType(proxy.getProtocol());
            pi.setNonProxyHosts(proxy.getNonProxyHosts());
            pi.setNtlmDomain(proxy.getNtlmDomain());
            pi.setNtlmHost(proxy.getNtlmHost());
            pi.setUserName(proxy.getUserName());
            pi.setPassword(proxy.getPassword());
        }
        return pi;
    }

    private void createReplacements(Repository repository, AuthenticationInfo authenticationInfo) {
        this.replacements = new HashMap<String, String>();
        String basedir = repository.getBasedir();
        if (basedir.endsWith("/")) {
            basedir = basedir.substring(0, basedir.length() - 1);
        }
        this.replacements.put("repository.basedir", basedir);
        String user = authenticationInfo != null ? authenticationInfo.getUserName() : "null";
        this.replacements.put("repository.user", user);
        this.replacements.put("repository.host", repository.getHost());
        this.replacements.put("repository.id", repository.getId());
    }

    private Wagon getWagon(Repository repository, WagonManager manager) throws MojoExecutionException {
        Wagon wagon;
        try {
            wagon = manager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            String shortMessage = "Unsupported protocol: '" + repository.getProtocol() + "' for site deployment to " + "distributionManagement.site.url=" + repository.getUrl() + ".";
            String longMessage = "\n" + shortMessage + "\n" + "Currently supported protocols are: " + this.getSupportedProtocols() + ".\n" + "    Protocols may be added through wagon providers.\n" + "    For more information, see " + "http://maven.apache.org/plugins/maven-site-plugin/examples/adding-deploy-protocol.html";
            this.getLog().error((CharSequence)longMessage);
            throw new MojoExecutionException(shortMessage);
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        return wagon;
    }

    private String getSupportedProtocols() {
        try {
            Set protocols = this.container.lookupMap(Wagon.class.getName()).keySet();
            return StringUtils.join(protocols.iterator(), (String)", ");
        }
        catch (ComponentLookupException e) {
            this.getLog().error((Throwable)e);
            return "";
        }
    }

    private void push(File f, Repository repository, Wagon wagon, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo, String targetPath) throws MojoExecutionException {
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            wagon.connect(repository, authenticationInfo, proxyInfo);
            if (!this.executePreCommands(wagon, repository) && this.failOnPreCommandErrors) {
                this.getLog().error((CharSequence)"Aborting due to previous errors");
                throw new MojoExecutionException("Aborting due to previous errors");
            }
            if (f.isDirectory()) {
                wagon.putDirectory(f, targetPath);
            } else {
                wagon.put(f, targetPath);
            }
            if (!this.executePostCommands(wagon, repository) && this.failOnPostCommandErrors) {
                this.getLog().error((CharSequence)"Aborting due to previous errors");
                throw new MojoExecutionException("Aborting due to previous errors");
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    private static void chmod(Wagon wagon, Repository repository, String chmodOptions, String chmodMode) throws MojoExecutionException {
        try {
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod " + chmodOptions + " " + chmodMode + " " + repository.getBasedir());
            }
        }
        catch (CommandExecutionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    private boolean executePreCommands(Wagon wagon, Repository repository) throws MojoExecutionException {
        if (wagon instanceof CommandExecutor) {
            return this.executeCommands((CommandExecutor)wagon, repository, this.preCommands, this.failOnPreCommandErrors);
        }
        return false;
    }

    private boolean executePostCommands(Wagon wagon, Repository repository) throws MojoExecutionException {
        if (wagon instanceof CommandExecutor) {
            return this.executeCommands((CommandExecutor)wagon, repository, this.postCommands, this.failOnPostCommandErrors);
        }
        return false;
    }

    private boolean executeCommands(CommandExecutor exec, Repository repository, List<String> commands, boolean failOnError) throws MojoExecutionException {
        if (commands == null || commands.size() == 0) {
            return true;
        }
        boolean rc = true;
        for (String cmd : commands) {
            if (!failOnError || (rc &= this.executeCommand(exec, repository, cmd, failOnError))) continue;
            return rc;
        }
        return rc;
    }

    private boolean executeCommand(CommandExecutor exec, Repository repository, String command, boolean doError) throws MojoExecutionException {
        boolean doFail;
        boolean bl = doFail = !command.startsWith("@");
        if (!doFail) {
            command = command.substring(1);
        }
        try {
            command = this.setVariables(command, this.replacements);
            this.getLog().info((CharSequence)("exec: " + command));
            exec.executeCommand(command);
        }
        catch (CommandExecutionException e) {
            boolean messageOnly;
            boolean bl2 = messageOnly = e.getMessage().indexOf("Exit code:") >= 0;
            if (doFail) {
                if (doError) {
                    if (messageOnly) {
                        this.getLog().error((CharSequence)("Command failed: " + command));
                        this.getLog().error((CharSequence)("  " + e.getLocalizedMessage()));
                    } else {
                        this.getLog().error((CharSequence)("Command failed: " + command), (Throwable)e);
                    }
                } else if (messageOnly) {
                    this.getLog().warn((CharSequence)("Command failed: " + command));
                    this.getLog().warn((CharSequence)("  " + e.getLocalizedMessage()));
                } else {
                    this.getLog().warn((CharSequence)("Command failed: " + command), (Throwable)e);
                }
                return false;
            }
            if (messageOnly) {
                this.getLog().warn((CharSequence)("Command failed: " + command));
                this.getLog().warn((CharSequence)("  " + e.getLocalizedMessage()));
            }
            this.getLog().warn((CharSequence)("Command failed: " + command), (Throwable)e);
        }
        return true;
    }

    private String setVariables(String command, Map<String, String> replacements) {
        if (replacements != null) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                String variable = entry.getKey();
                String value = entry.getValue();
                command = command.replaceAll("\\$" + variable, value);
            }
        }
        return command;
    }

    private static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws TransferFailedException {
        log.debug((CharSequence)" configureWagon ");
        for (Server server : settings.getServers()) {
            String id = server.getId();
            log.debug((CharSequence)("configureWagon server " + id));
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
            ComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE, "basic");
                componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, container.getContainerRealm());
            }
            catch (ComponentLookupException e) {
                throw new TransferFailedException("While configuring wagon for '" + repositoryId + "': Unable to lookup wagon configurator." + " Wagon configuration cannot be applied.", (Throwable)e);
            }
            catch (ComponentConfigurationException e) {
                throw new TransferFailedException("While configuring wagon for '" + repositoryId + "': Unable to apply wagon configuration.", (Throwable)e);
            }
            finally {
                if (componentConfigurator == null) continue;
                try {
                    container.release((Object)componentConfigurator);
                }
                catch (ComponentLifecycleException e) {
                    log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
                }
            }
        }
    }
}

