/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import eu.chainfire.libsuperuser.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class StreamGobbler
extends Thread {
    private String shell = null;
    private BufferedReader reader = null;
    private List<String> writer = null;
    private OnLineListener listener = null;

    public StreamGobbler(String shell, InputStream inputStream, List<String> outputList) {
        this.shell = shell;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = outputList;
    }

    public StreamGobbler(String shell, InputStream inputStream, OnLineListener onLineListener) {
        this.shell = shell;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.listener = onLineListener;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                Debug.logOutput(String.format("[%s] %s", this.shell, line));
                if (this.writer != null) {
                    this.writer.add(line);
                }
                if (this.listener == null) continue;
                this.listener.onLine(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface OnLineListener {
        public void onLine(String var1);
    }
}

