/*
 * Decompiled with CFR 0.152.
 */
package eu.chainfire.libsuperuser;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import eu.chainfire.libsuperuser.Debug;
import eu.chainfire.libsuperuser.ShellNotClosedException;
import eu.chainfire.libsuperuser.ShellOnMainThreadException;
import eu.chainfire.libsuperuser.StreamGobbler;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Shell {
    protected static String[] availableTestCommands = new String[]{"echo -BOC-", "id"};

    @Deprecated
    public static List<String> run(String shell, String[] commands, boolean wantSTDERR) {
        return Shell.run(shell, commands, null, wantSTDERR);
    }

    public static List<String> run(String shell, String[] commands, String[] environment, boolean wantSTDERR) {
        String shellUpper = shell.toUpperCase(Locale.ENGLISH);
        if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
            Debug.log("Application attempted to run a shell command from the main thread");
            throw new ShellOnMainThreadException("Application attempted to run a shell command from the main thread");
        }
        Debug.logCommand(String.format("[%s%%] START", shellUpper));
        List<String> res = Collections.synchronizedList(new ArrayList());
        try {
            StreamGobbler STDERR;
            StreamGobbler STDOUT;
            DataOutputStream STDIN;
            Process process;
            block13: {
                if (environment != null) {
                    HashMap<String, String> newEnvironment = new HashMap<String, String>();
                    newEnvironment.putAll(System.getenv());
                    for (String entry : environment) {
                        int split = entry.indexOf("=");
                        if (split < 0) continue;
                        newEnvironment.put(entry.substring(0, split), entry.substring(split + 1));
                    }
                    int i = 0;
                    environment = new String[newEnvironment.size()];
                    for (Map.Entry entry : newEnvironment.entrySet()) {
                        environment[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                        ++i;
                    }
                }
                process = Runtime.getRuntime().exec(shell, environment);
                STDIN = new DataOutputStream(process.getOutputStream());
                STDOUT = new StreamGobbler(shellUpper + "-", process.getInputStream(), res);
                STDERR = new StreamGobbler(shellUpper + "*", process.getErrorStream(), wantSTDERR ? res : null);
                STDOUT.start();
                STDERR.start();
                try {
                    for (String write : commands) {
                        Debug.logCommand(String.format("[%s+] %s", shellUpper, write));
                        STDIN.write((write + "\n").getBytes("UTF-8"));
                        STDIN.flush();
                    }
                    STDIN.write("exit\n".getBytes("UTF-8"));
                    STDIN.flush();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("EPIPE")) break block13;
                    throw e;
                }
            }
            process.waitFor();
            try {
                STDIN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            STDOUT.join();
            STDERR.join();
            process.destroy();
            if (SU.isSU(shell) && process.exitValue() == 255) {
                res = null;
            }
        }
        catch (IOException e) {
            res = null;
        }
        catch (InterruptedException e) {
            res = null;
        }
        Debug.logCommand(String.format("[%s%%] END", shell.toUpperCase(Locale.ENGLISH)));
        return res;
    }

    protected static boolean parseAvailableResult(List<String> ret, boolean checkForRoot) {
        if (ret == null) {
            return false;
        }
        boolean echo_seen = false;
        for (String line : ret) {
            if (line.contains("uid=")) {
                return !checkForRoot || line.contains("uid=0");
            }
            if (!line.contains("-BOC-")) continue;
            echo_seen = true;
        }
        return echo_seen;
    }

    public static class Interactive {
        private final Handler handler;
        private final boolean autoHandler;
        private final String shell;
        private final boolean wantSTDERR;
        private final List<Command> commands;
        private final Map<String, String> environment;
        private final StreamGobbler.OnLineListener onSTDOUTLineListener;
        private final StreamGobbler.OnLineListener onSTDERRLineListener;
        private int watchdogTimeout;
        private Process process = null;
        private DataOutputStream STDIN = null;
        private StreamGobbler STDOUT = null;
        private StreamGobbler STDERR = null;
        private ScheduledThreadPoolExecutor watchdog = null;
        private volatile boolean running = false;
        private volatile boolean idle = true;
        private volatile boolean closed = true;
        private volatile int callbacks = 0;
        private volatile int watchdogCount;
        private final Object idleSync = new Object();
        private final Object callbackSync = new Object();
        private volatile int lastExitCode = 0;
        private volatile String lastMarkerSTDOUT = null;
        private volatile String lastMarkerSTDERR = null;
        private volatile Command command = null;
        private volatile List<String> buffer = null;

        private Interactive(final Builder builder, final OnCommandResultListener onCommandResultListener) {
            this.autoHandler = builder.autoHandler;
            this.shell = builder.shell;
            this.wantSTDERR = builder.wantSTDERR;
            this.commands = builder.commands;
            this.environment = builder.environment;
            this.onSTDOUTLineListener = builder.onSTDOUTLineListener;
            this.onSTDERRLineListener = builder.onSTDERRLineListener;
            this.watchdogTimeout = builder.watchdogTimeout;
            this.handler = Looper.myLooper() != null && builder.handler == null && this.autoHandler ? new Handler() : builder.handler;
            if (onCommandResultListener != null) {
                this.watchdogTimeout = 60;
                this.commands.add(0, new Command(availableTestCommands, 0, new OnCommandResultListener(){

                    @Override
                    public void onCommandResult(int commandCode, int exitCode, List<String> output) {
                        if (exitCode == 0 && !Shell.parseAvailableResult(output, SU.isSU(Interactive.this.shell))) {
                            exitCode = -4;
                        }
                        Interactive.this.watchdogTimeout = builder.watchdogTimeout;
                        onCommandResultListener.onCommandResult(0, exitCode, output);
                    }
                }, null));
            }
            if (!this.open() && onCommandResultListener != null) {
                onCommandResultListener.onCommandResult(0, -3, null);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.closed && Debug.getSanityChecksEnabledEffective()) {
                Debug.log("Application did not close() interactive shell");
                throw new ShellNotClosedException();
            }
            super.finalize();
        }

        public void addCommand(String command) {
            this.addCommand(command, 0, (OnCommandResultListener)null);
        }

        public void addCommand(String command, int code, OnCommandResultListener onCommandResultListener) {
            this.addCommand(new String[]{command}, code, onCommandResultListener);
        }

        public void addCommand(String command, int code, OnCommandLineListener onCommandLineListener) {
            this.addCommand(new String[]{command}, code, onCommandLineListener);
        }

        public void addCommand(List<String> commands) {
            this.addCommand(commands, 0, (OnCommandResultListener)null);
        }

        public void addCommand(List<String> commands, int code, OnCommandResultListener onCommandResultListener) {
            this.addCommand(commands.toArray(new String[commands.size()]), code, onCommandResultListener);
        }

        public void addCommand(List<String> commands, int code, OnCommandLineListener onCommandLineListener) {
            this.addCommand(commands.toArray(new String[commands.size()]), code, onCommandLineListener);
        }

        public void addCommand(String[] commands) {
            this.addCommand(commands, 0, (OnCommandResultListener)null);
        }

        public synchronized void addCommand(String[] commands, int code, OnCommandResultListener onCommandResultListener) {
            this.commands.add(new Command(commands, code, onCommandResultListener, null));
            this.runNextCommand();
        }

        public synchronized void addCommand(String[] commands, int code, OnCommandLineListener onCommandLineListener) {
            this.commands.add(new Command(commands, code, null, onCommandLineListener));
            this.runNextCommand();
        }

        private void runNextCommand() {
            this.runNextCommand(true);
        }

        private synchronized void handleWatchdog() {
            int exitCode;
            if (this.watchdog == null) {
                return;
            }
            if (this.watchdogTimeout == 0) {
                return;
            }
            if (!this.isRunning()) {
                exitCode = -2;
                Debug.log(String.format("[%s%%] SHELL_DIED", this.shell.toUpperCase(Locale.ENGLISH)));
            } else {
                if (this.watchdogCount++ < this.watchdogTimeout) {
                    return;
                }
                exitCode = -1;
                Debug.log(String.format("[%s%%] WATCHDOG_EXIT", this.shell.toUpperCase(Locale.ENGLISH)));
            }
            this.postCallback(this.command, exitCode, this.buffer);
            this.command = null;
            this.buffer = null;
            this.idle = true;
            this.watchdog.shutdown();
            this.watchdog = null;
            this.kill();
        }

        private void startWatchdog() {
            if (this.watchdogTimeout == 0) {
                return;
            }
            this.watchdogCount = 0;
            this.watchdog = new ScheduledThreadPoolExecutor(1);
            this.watchdog.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Interactive.this.handleWatchdog();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }

        private void stopWatchdog() {
            if (this.watchdog != null) {
                this.watchdog.shutdownNow();
                this.watchdog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runNextCommand(boolean notifyIdle) {
            boolean running = this.isRunning();
            if (!running) {
                this.idle = true;
            }
            if (running && this.idle && this.commands.size() > 0) {
                Command command = this.commands.get(0);
                this.commands.remove(0);
                this.buffer = null;
                this.lastExitCode = 0;
                this.lastMarkerSTDOUT = null;
                this.lastMarkerSTDERR = null;
                if (command.commands.length > 0) {
                    try {
                        if (command.onCommandResultListener != null) {
                            this.buffer = Collections.synchronizedList(new ArrayList());
                        }
                        this.idle = false;
                        this.command = command;
                        this.startWatchdog();
                        for (String write : command.commands) {
                            Debug.logCommand(String.format("[%s+] %s", this.shell.toUpperCase(Locale.ENGLISH), write));
                            this.STDIN.write((write + "\n").getBytes("UTF-8"));
                        }
                        this.STDIN.write(("echo " + command.marker + " $?\n").getBytes("UTF-8"));
                        this.STDIN.write(("echo " + command.marker + " >&2\n").getBytes("UTF-8"));
                        this.STDIN.flush();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.runNextCommand(false);
                }
            } else if (!running) {
                while (this.commands.size() > 0) {
                    this.postCallback(this.commands.remove(0), -2, null);
                }
            }
            if (this.idle && notifyIdle) {
                Object object = this.idleSync;
                synchronized (object) {
                    this.idleSync.notifyAll();
                }
            }
        }

        private synchronized void processMarker() {
            if (this.command.marker.equals(this.lastMarkerSTDOUT) && this.command.marker.equals(this.lastMarkerSTDERR)) {
                this.postCallback(this.command, this.lastExitCode, this.buffer);
                this.stopWatchdog();
                this.command = null;
                this.buffer = null;
                this.idle = true;
                this.runNextCommand();
            }
        }

        private synchronized void processLine(String line, StreamGobbler.OnLineListener listener) {
            if (listener != null) {
                if (this.handler != null) {
                    final String fLine = line;
                    final StreamGobbler.OnLineListener fListener = listener;
                    this.startCallback();
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fListener.onLine(fLine);
                            }
                            finally {
                                Interactive.this.endCallback();
                            }
                        }
                    });
                } else {
                    listener.onLine(line);
                }
            }
        }

        private synchronized void addBuffer(String line) {
            if (this.buffer != null) {
                this.buffer.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                ++this.callbacks;
            }
        }

        private void postCallback(final Command fCommand, final int fExitCode, final List<String> fOutput) {
            if (fCommand.onCommandResultListener == null && fCommand.onCommandLineListener == null) {
                return;
            }
            if (this.handler == null) {
                if (fCommand.onCommandResultListener != null) {
                    fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fOutput);
                }
                if (fCommand.onCommandLineListener != null) {
                    fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                }
                return;
            }
            this.startCallback();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (fCommand.onCommandResultListener != null) {
                            fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fOutput);
                        }
                        if (fCommand.onCommandLineListener != null) {
                            fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                        }
                    }
                    finally {
                        Interactive.this.endCallback();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                --this.callbacks;
                if (this.callbacks == 0) {
                    this.callbackSync.notifyAll();
                }
            }
        }

        private synchronized boolean open() {
            Debug.log(String.format("[%s%%] START", this.shell.toUpperCase(Locale.ENGLISH)));
            try {
                if (this.environment.size() == 0) {
                    this.process = Runtime.getRuntime().exec(this.shell);
                } else {
                    HashMap<String, String> newEnvironment = new HashMap<String, String>();
                    newEnvironment.putAll(System.getenv());
                    newEnvironment.putAll(this.environment);
                    int i = 0;
                    String[] env = new String[newEnvironment.size()];
                    for (Map.Entry entry : newEnvironment.entrySet()) {
                        env[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                        ++i;
                    }
                    this.process = Runtime.getRuntime().exec(this.shell, env);
                }
                this.STDIN = new DataOutputStream(this.process.getOutputStream());
                this.STDOUT = new StreamGobbler(this.shell.toUpperCase(Locale.ENGLISH) + "-", this.process.getInputStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(String line) {
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            String markerPart = null;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                                markerPart = line;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                                markerPart = line.substring(markerIndex);
                            }
                            if (contentPart != null) {
                                Interactive.this.addBuffer(contentPart);
                                Interactive.this.processLine(contentPart, Interactive.this.onSTDOUTLineListener);
                                Interactive.this.processLine(contentPart, Interactive.this.command.onCommandLineListener);
                            }
                            if (markerPart != null) {
                                try {
                                    Interactive.this.lastExitCode = Integer.valueOf(markerPart.substring(Interactive.this.command.marker.length() + 1), 10);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                Interactive.this.lastMarkerSTDOUT = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                });
                this.STDERR = new StreamGobbler(this.shell.toUpperCase(Locale.ENGLISH) + "*", this.process.getErrorStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(String line) {
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                            }
                            if (contentPart != null) {
                                if (Interactive.this.wantSTDERR) {
                                    Interactive.this.addBuffer(contentPart);
                                }
                                Interactive.this.processLine(contentPart, Interactive.this.onSTDERRLineListener);
                            }
                            if (markerIndex >= 0) {
                                Interactive.this.lastMarkerSTDERR = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                });
                this.STDOUT.start();
                this.STDERR.start();
                this.running = true;
                this.closed = false;
                this.runNextCommand();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean _idle = this.isIdle();
            Interactive interactive = this;
            synchronized (interactive) {
                if (!this.running) {
                    return;
                }
                this.running = false;
                this.closed = true;
            }
            if (!_idle && Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to wait for a non-idle shell to close on the main thread");
                throw new ShellOnMainThreadException("Application attempted to wait for a non-idle shell to close on the main thread");
            }
            if (!_idle) {
                this.waitForIdle();
            }
            try {
                block13: {
                    try {
                        this.STDIN.write("exit\n".getBytes("UTF-8"));
                        this.STDIN.flush();
                    }
                    catch (IOException e) {
                        if (e.getMessage().contains("EPIPE")) break block13;
                        throw e;
                    }
                }
                this.process.waitFor();
                try {
                    this.STDIN.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.STDOUT.join();
                this.STDERR.join();
                this.stopWatchdog();
                this.process.destroy();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Debug.log(String.format("[%s%%] END", this.shell.toUpperCase(Locale.ENGLISH)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void kill() {
            this.running = false;
            this.closed = true;
            try {
                this.STDIN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.idle = true;
            Object object = this.idleSync;
            synchronized (object) {
                this.idleSync.notifyAll();
            }
        }

        public boolean isRunning() {
            if (this.process == null) {
                return false;
            }
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isIdle() {
            if (!this.isRunning()) {
                this.idle = true;
                Object object = this.idleSync;
                synchronized (object) {
                    this.idleSync.notifyAll();
                }
            }
            return this.idle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForIdle() {
            if (Debug.getSanityChecksEnabledEffective() && Debug.onMainThread()) {
                Debug.log("Application attempted to wait for a shell to become idle on the main thread");
                throw new ShellOnMainThreadException("Application attempted to wait for a shell to become idle on the main thread");
            }
            if (this.isRunning()) {
                Object object = this.idleSync;
                synchronized (object) {
                    while (!this.idle) {
                        try {
                            this.idleSync.wait();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
                if (this.handler != null && this.handler.getLooper() != null && this.handler.getLooper() != Looper.myLooper()) {
                    object = this.callbackSync;
                    synchronized (object) {
                        while (this.callbacks > 0) {
                            try {
                                this.callbackSync.wait();
                            }
                            catch (InterruptedException e) {
                                return false;
                            }
                        }
                    }
                }
            }
            return true;
        }

        public boolean hasHandler() {
            return this.handler != null;
        }
    }

    public static class Builder {
        private Handler handler = null;
        private boolean autoHandler = true;
        private String shell = "sh";
        private boolean wantSTDERR = false;
        private List<Command> commands = new LinkedList<Command>();
        private Map<String, String> environment = new HashMap<String, String>();
        private StreamGobbler.OnLineListener onSTDOUTLineListener = null;
        private StreamGobbler.OnLineListener onSTDERRLineListener = null;
        private int watchdogTimeout = 0;

        public Builder setHandler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setAutoHandler(boolean autoHandler) {
            this.autoHandler = autoHandler;
            return this;
        }

        public Builder setShell(String shell) {
            this.shell = shell;
            return this;
        }

        public Builder useSH() {
            return this.setShell("sh");
        }

        public Builder useSU() {
            return this.setShell("su");
        }

        public Builder setWantSTDERR(boolean wantSTDERR) {
            this.wantSTDERR = wantSTDERR;
            return this;
        }

        public Builder addEnvironment(String key, String value) {
            this.environment.put(key, value);
            return this;
        }

        public Builder addEnvironment(Map<String, String> addEnvironment) {
            this.environment.putAll(addEnvironment);
            return this;
        }

        public Builder addCommand(String command) {
            return this.addCommand(command, 0, null);
        }

        public Builder addCommand(String command, int code, OnCommandResultListener onCommandResultListener) {
            return this.addCommand(new String[]{command}, code, onCommandResultListener);
        }

        public Builder addCommand(List<String> commands) {
            return this.addCommand(commands, 0, null);
        }

        public Builder addCommand(List<String> commands, int code, OnCommandResultListener onCommandResultListener) {
            return this.addCommand(commands.toArray(new String[commands.size()]), code, onCommandResultListener);
        }

        public Builder addCommand(String[] commands) {
            return this.addCommand(commands, 0, null);
        }

        public Builder addCommand(String[] commands, int code, OnCommandResultListener onCommandResultListener) {
            this.commands.add(new Command(commands, code, onCommandResultListener, null));
            return this;
        }

        public Builder setOnSTDOUTLineListener(StreamGobbler.OnLineListener onLineListener) {
            this.onSTDOUTLineListener = onLineListener;
            return this;
        }

        public Builder setOnSTDERRLineListener(StreamGobbler.OnLineListener onLineListener) {
            this.onSTDERRLineListener = onLineListener;
            return this;
        }

        public Builder setWatchdogTimeout(int watchdogTimeout) {
            this.watchdogTimeout = watchdogTimeout;
            return this;
        }

        public Builder setMinimalLogging(boolean useMinimal) {
            Debug.setLogTypeEnabled(6, !useMinimal);
            return this;
        }

        public Interactive open() {
            return new Interactive(this, null);
        }

        public Interactive open(OnCommandResultListener onCommandResultListener) {
            return new Interactive(this, onCommandResultListener);
        }
    }

    private static class Command {
        private static int commandCounter = 0;
        private final String[] commands;
        private final int code;
        private final OnCommandResultListener onCommandResultListener;
        private final OnCommandLineListener onCommandLineListener;
        private final String marker;

        public Command(String[] commands, int code, OnCommandResultListener onCommandResultListener, OnCommandLineListener onCommandLineListener) {
            this.commands = commands;
            this.code = code;
            this.onCommandResultListener = onCommandResultListener;
            this.onCommandLineListener = onCommandLineListener;
            this.marker = UUID.randomUUID().toString() + String.format("-%08x", ++commandCounter);
        }
    }

    public static interface OnCommandLineListener
    extends OnResult,
    StreamGobbler.OnLineListener {
        public void onCommandResult(int var1, int var2);
    }

    public static interface OnCommandResultListener
    extends OnResult {
        public void onCommandResult(int var1, int var2, List<String> var3);
    }

    private static interface OnResult {
        public static final int WATCHDOG_EXIT = -1;
        public static final int SHELL_DIED = -2;
        public static final int SHELL_EXEC_FAILED = -3;
        public static final int SHELL_WRONG_UID = -4;
        public static final int SHELL_RUNNING = 0;
    }

    public static class SU {
        private static Boolean isSELinuxEnforcing = null;
        private static String[] suVersion = new String[]{null, null};

        public static List<String> run(String command) {
            return Shell.run("su", new String[]{command}, null, false);
        }

        public static List<String> run(List<String> commands) {
            return Shell.run("su", commands.toArray(new String[commands.size()]), null, false);
        }

        public static List<String> run(String[] commands) {
            return Shell.run("su", commands, null, false);
        }

        public static boolean available() {
            List<String> ret = SU.run(availableTestCommands);
            return Shell.parseAvailableResult(ret, true);
        }

        public static synchronized String version(boolean internal) {
            int idx;
            int n = idx = internal ? 0 : 1;
            if (suVersion[idx] == null) {
                String version = null;
                List<String> ret = Shell.run(internal ? "su -V" : "su -v", new String[]{"exit"}, null, false);
                if (ret != null) {
                    for (String line : ret) {
                        if (!internal) {
                            if (line.trim().equals("")) continue;
                            version = line;
                            break;
                        }
                        try {
                            if (Integer.parseInt(line) <= 0) continue;
                            version = line;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                }
                SU.suVersion[idx] = version;
            }
            return suVersion[idx];
        }

        public static boolean isSU(String shell) {
            int pos = shell.indexOf(32);
            if (pos >= 0) {
                shell = shell.substring(0, pos);
            }
            if ((pos = shell.lastIndexOf(47)) >= 0) {
                shell = shell.substring(pos + 1);
            }
            return shell.equals("su");
        }

        public static String shell(int uid, String context) {
            String shell = "su";
            if (context != null && SU.isSELinuxEnforcing()) {
                String display = SU.version(false);
                String internal = SU.version(true);
                if (display != null && internal != null && display.endsWith("SUPERSU") && Integer.valueOf(internal) >= 190) {
                    shell = String.format(Locale.ENGLISH, "%s --context %s", shell, context);
                }
            }
            if (uid > 0) {
                shell = String.format(Locale.ENGLISH, "%s %d", shell, uid);
            }
            return shell;
        }

        public static String shellMountMaster() {
            if (Build.VERSION.SDK_INT >= 17) {
                return "su --mount-master";
            }
            return "su";
        }

        public static synchronized boolean isSELinuxEnforcing() {
            if (isSELinuxEnforcing == null) {
                Boolean enforcing = null;
                if (Build.VERSION.SDK_INT >= 17) {
                    File f = new File("/sys/fs/selinux/enforce");
                    if (f.exists()) {
                        try (FileInputStream is2 = new FileInputStream("/sys/fs/selinux/enforce");){
                            enforcing = ((InputStream)is2).read() == 49;
                        }
                        catch (Exception is2) {
                            // empty catch block
                        }
                    }
                    if (enforcing == null) {
                        try {
                            Class<?> seLinux = Class.forName("android.os.SELinux");
                            Method isSELinuxEnforced = seLinux.getMethod("isSELinuxEnforced", new Class[0]);
                            enforcing = (Boolean)isSELinuxEnforced.invoke(seLinux.newInstance(), new Object[0]);
                        }
                        catch (Exception e) {
                            enforcing = Build.VERSION.SDK_INT >= 19;
                        }
                    }
                }
                if (enforcing == null) {
                    enforcing = false;
                }
                isSELinuxEnforcing = enforcing;
            }
            return isSELinuxEnforcing;
        }

        public static synchronized void clearCachedResults() {
            isSELinuxEnforcing = null;
            SU.suVersion[0] = null;
            SU.suVersion[1] = null;
        }
    }

    public static class SH {
        public static List<String> run(String command) {
            return Shell.run("sh", new String[]{command}, null, false);
        }

        public static List<String> run(List<String> commands) {
            return Shell.run("sh", commands.toArray(new String[commands.size()]), null, false);
        }

        public static List<String> run(String[] commands) {
            return Shell.run("sh", commands, null, false);
        }
    }
}

