/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import com.google.common.net.InternetDomainName;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import edu.uci.ics.crawler4j.url.TLDList;
import java.io.Serializable;
import java.util.Map;

@Entity
public class WebURL
implements Serializable {
    private static final long serialVersionUID = 1L;
    @PrimaryKey
    private String url;
    private int docid;
    private int parentDocid;
    private String parentUrl;
    private short depth;
    private String registeredDomain;
    private String subDomain;
    private String path;
    private String anchor;
    private byte priority;
    private String tag;
    private Map<String, String> attributes;
    private TLDList tldList;

    public void setTldList(TLDList tldList) {
        this.tldList = tldList;
    }

    public int getDocid() {
        return this.docid;
    }

    public void setDocid(int docid) {
        this.docid = docid;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        String domain;
        this.url = url;
        int domainStartIdx = url.indexOf("//") + 2;
        int domainEndIdx = url.indexOf(47, domainStartIdx);
        domainEndIdx = domainEndIdx > domainStartIdx ? domainEndIdx : url.length();
        this.registeredDomain = domain = url.substring(domainStartIdx, domainEndIdx);
        this.subDomain = "";
        if (this.tldList != null && !domain.isEmpty() && InternetDomainName.isValid((String)domain)) {
            String candidate = null;
            String rd = null;
            String sd = null;
            String[] parts = domain.split("\\.");
            for (int i = parts.length - 1; i >= 0; --i) {
                if (rd == null) {
                    if (!this.tldList.isRegisteredDomain(candidate = candidate == null ? parts[i] : parts[i] + "." + candidate)) continue;
                    rd = candidate;
                    continue;
                }
                sd = sd == null ? parts[i] : parts[i] + "." + sd;
            }
            if (rd != null) {
                this.registeredDomain = rd;
            }
            if (sd != null) {
                this.subDomain = sd;
            }
        }
        this.path = url.substring(domainEndIdx);
        int pathEndIdx = this.path.indexOf(63);
        if (pathEndIdx >= 0) {
            this.path = this.path.substring(0, pathEndIdx);
        }
    }

    public int getParentDocid() {
        return this.parentDocid;
    }

    public void setParentDocid(int parentDocid) {
        this.parentDocid = parentDocid;
    }

    public String getParentUrl() {
        return this.parentUrl;
    }

    public void setParentUrl(String parentUrl) {
        this.parentUrl = parentUrl;
    }

    public short getDepth() {
        return this.depth;
    }

    public void setDepth(short depth) {
        this.depth = depth;
    }

    public String getDomain() {
        return this.registeredDomain;
    }

    public String getSubDomain() {
        return this.subDomain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        return this.attributes.getOrDefault(name, "");
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebURL otherUrl = (WebURL)o;
        return this.url != null && this.url.equals(otherUrl.getURL());
    }

    public String toString() {
        return this.url;
    }
}

