/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import com.google.common.net.InternetDomainName;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixListFactory;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLDList {
    private final Logger logger = LoggerFactory.getLogger(TLDList.class);
    private boolean onlineUpdate;
    private PublicSuffixList publicSuffixList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLDList(CrawlConfig config) throws IOException {
        this.onlineUpdate = config.isOnlineTldListUpdate();
        if (this.onlineUpdate) {
            InputStream stream;
            String filename = config.getPublicSuffixLocalFile();
            if (filename == null) {
                URL url = new URL(config.getPublicSuffixSourceUrl());
                stream = url.openStream();
            } else {
                stream = new FileInputStream(filename);
            }
            try {
                this.publicSuffixList = new PublicSuffixListFactory().build(stream);
            }
            finally {
                stream.close();
            }
        }
    }

    public boolean contains(String domain) {
        if (this.onlineUpdate) {
            return this.publicSuffixList.isPublicSuffix(domain);
        }
        return InternetDomainName.from((String)domain).isPublicSuffix();
    }

    public boolean isRegisteredDomain(String domain) {
        if (this.onlineUpdate) {
            return this.publicSuffixList.isRegistrable(domain);
        }
        return InternetDomainName.from((String)domain).isTopPrivateDomain();
    }
}

