/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathRule {
    protected static final Logger logger = LoggerFactory.getLogger(PathRule.class);
    public int type;
    public Pattern pattern;

    public static Pattern robotsPatternToRegexp(String pattern) {
        StringBuilder regexp = new StringBuilder();
        regexp.append('^');
        StringBuilder quoteBuf = new StringBuilder();
        boolean terminated = false;
        if (pattern.isEmpty()) {
            return Pattern.compile("^$");
        }
        for (int pos = 0; pos < pattern.length(); ++pos) {
            char ch = pattern.charAt(pos);
            if (ch == '\\') {
                char nch;
                char c = nch = pos < pattern.length() - 1 ? pattern.charAt(pos + 1) : (char)'\u0000';
                if (nch == '*' || ch == '$') {
                    quoteBuf.append(nch);
                    ++pos;
                    continue;
                }
                quoteBuf.append(ch);
                continue;
            }
            if (ch == '*') {
                if (quoteBuf.length() > 0) {
                    regexp.append("\\Q").append((CharSequence)quoteBuf).append("\\E");
                    quoteBuf = new StringBuilder();
                }
                if (pos == pattern.length() - 1) {
                    terminated = true;
                    regexp.append(".*");
                    continue;
                }
                regexp.append(".+");
                continue;
            }
            if (ch == '$' && pos == pattern.length() - 1) {
                if (quoteBuf.length() > 0) {
                    regexp.append("\\Q").append((CharSequence)quoteBuf).append("\\E");
                    quoteBuf = new StringBuilder();
                }
                regexp.append(ch);
                terminated = true;
                continue;
            }
            quoteBuf.append(ch);
        }
        if (quoteBuf.length() > 0) {
            regexp.append("\\Q").append((CharSequence)quoteBuf).append("\\E");
        }
        if (!terminated) {
            regexp.append(".*");
        }
        return Pattern.compile(regexp.toString());
    }

    public static boolean matchesRobotsPattern(String pattern, String path) {
        return PathRule.robotsPatternToRegexp(pattern).matcher(path).matches();
    }

    public PathRule(int type, String pattern) {
        this.type = type;
        this.pattern = PathRule.robotsPatternToRegexp(pattern);
    }

    public boolean matches(String path) {
        return this.pattern.matcher(path).matches();
    }
}

