/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.parser;

import edu.uci.ics.crawler4j.parser.TextParseData;
import edu.uci.ics.crawler4j.url.URLCanonicalizer;
import edu.uci.ics.crawler4j.url.WebURL;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssParseData
extends TextParseData {
    private static final Pattern pattern = CssParseData.initializePattern();

    private Set<WebURL> parseOutgoingUrls(WebURL referringPage) throws UnsupportedEncodingException {
        Set<String> extractedUrls = CssParseData.extractUrlInCssText(this.getTextContent());
        String pagePath = referringPage.getPath();
        String pageUrl = referringPage.getURL();
        HashSet<WebURL> outgoingUrls = new HashSet<WebURL>();
        for (String url : extractedUrls) {
            String relative = CssParseData.getLinkRelativeTo(pagePath, url);
            String absolute = CssParseData.getAbsoluteUrlFrom(URLCanonicalizer.getCanonicalURL(pageUrl), relative);
            WebURL webURL = new WebURL();
            webURL.setURL(absolute);
            outgoingUrls.add(webURL);
        }
        return outgoingUrls;
    }

    public void setOutgoingUrls(WebURL referringPage) throws UnsupportedEncodingException {
        Set<WebURL> outgoingUrls = this.parseOutgoingUrls(referringPage);
        this.setOutgoingUrls(outgoingUrls);
    }

    private static Set<String> extractUrlInCssText(String input) {
        HashSet<String> extractedUrls = new HashSet<String>();
        if (input == null || input.isEmpty()) {
            return extractedUrls;
        }
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String url = matcher.group(1);
            if (url == null) {
                url = matcher.group(2);
            }
            if (url == null) {
                url = matcher.group(3);
            }
            if (url == null || url.startsWith("data:")) continue;
            extractedUrls.add(url);
        }
        return extractedUrls;
    }

    private static Pattern initializePattern() {
        return Pattern.compile("url\\(\\s*'([^\\)]+)'\\s*\\)|url\\(\\s*\"([^\\)]+)\"\\s*\\)|url\\(\\s*([^\\)]+)\\s*\\)|\\/\\*(\\*(?!\\/)|[^*])*\\*\\/");
    }

    private static String getAbsoluteUrlFrom(String pageUrl, String linkPath) {
        String domainUrl = CssParseData.getFullDomainFromUrl(pageUrl);
        if (linkPath.startsWith("/")) {
            return domainUrl + linkPath;
        }
        return domainUrl + "/" + linkPath;
    }

    private static String getLinkRelativeTo(String pagePath, String linkUrl) {
        if (linkUrl.startsWith("/") && !linkUrl.startsWith("//")) {
            return linkUrl;
        }
        if (linkUrl.startsWith("//")) {
            linkUrl = "http" + linkUrl;
        }
        if (linkUrl.startsWith("http")) {
            String domainUrl = CssParseData.getPathFromUrl(linkUrl);
            return domainUrl;
        }
        if (linkUrl.startsWith("../")) {
            String[] parts = pagePath.split("/");
            int pos = linkUrl.lastIndexOf("../") + 3;
            int parents = pos / 3;
            long diff = parts.length - parents - 1;
            String absolute = "";
            int i = 0;
            while ((long)i < diff) {
                String dir = parts[i];
                if (!dir.isEmpty()) {
                    absolute = absolute + "/" + dir;
                }
                ++i;
            }
            return absolute + "/" + linkUrl.substring(pos);
        }
        String root = CssParseData.getDirsFromUrl(pagePath);
        return root + linkUrl;
    }

    private static String getDirsFromUrl(String urlPath) {
        int pos = urlPath.lastIndexOf("/") + 1;
        String root = urlPath.substring(0, pos);
        return root;
    }

    private static String getPathFromUrl(String url) {
        int pos1 = url.indexOf("//") + 2;
        int pos2 = url.indexOf("/", pos1);
        String path = url.substring(pos2);
        return path;
    }

    private static String getFullDomainFromUrl(String url) {
        int pos1 = url.indexOf("//") + 2;
        int pos2 = url.indexOf("/", pos1);
        String path = url.substring(0, pos2);
        return path;
    }
}

