/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocIDServer {
    private static final Logger logger = LoggerFactory.getLogger(DocIDServer.class);
    private final Database docIDsDB;
    private static final String DATABASE_NAME = "DocIDs";
    private final Object mutex = new Object();
    private CrawlConfig config;
    private int lastDocID;

    public DocIDServer(Environment env, CrawlConfig config) {
        int docCount;
        this.config = config;
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(config.isResumableCrawling());
        dbConfig.setDeferredWrite(!config.isResumableCrawling());
        this.lastDocID = 0;
        this.docIDsDB = env.openDatabase(null, DATABASE_NAME, dbConfig);
        if (config.isResumableCrawling() && (docCount = this.getDocCount()) > 0) {
            logger.info("Loaded {} URLs that had been detected in previous crawl.", (Object)docCount);
            this.lastDocID = docCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocId(String url) {
        Object object = this.mutex;
        synchronized (object) {
            OperationStatus result = null;
            DatabaseEntry value = new DatabaseEntry();
            try {
                DatabaseEntry key = new DatabaseEntry(url.getBytes());
                result = this.docIDsDB.get(null, key, value, null);
            }
            catch (RuntimeException e) {
                if (this.config.isHaltOnError()) {
                    throw e;
                }
                logger.error("Exception thrown while getting DocID", (Throwable)e);
                return -1;
            }
            if (result == OperationStatus.SUCCESS && value.getData().length > 0) {
                return Util.byteArray2Int(value.getData());
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewDocID(String url) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                int docID = this.getDocId(url);
                if (docID > 0) {
                    return docID;
                }
                ++this.lastDocID;
                this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(this.lastDocID)));
                return this.lastDocID;
            }
            catch (RuntimeException e) {
                if (this.config.isHaltOnError()) {
                    throw e;
                }
                logger.error("Exception thrown while getting new DocID", (Throwable)e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrlAndDocId(String url, int docId) {
        Object object = this.mutex;
        synchronized (object) {
            if (docId <= this.lastDocID) {
                throw new IllegalArgumentException("Requested doc id: " + docId + " is not larger than: " + this.lastDocID);
            }
            int prevDocid = this.getDocId(url);
            if (prevDocid > 0) {
                if (prevDocid == docId) {
                    return;
                }
                throw new IllegalArgumentException("Doc id: " + prevDocid + " is already assigned to URL: " + url);
            }
            this.docIDsDB.put(null, new DatabaseEntry(url.getBytes()), new DatabaseEntry(Util.int2ByteArray(docId)));
            this.lastDocID = docId;
        }
    }

    public boolean isSeenBefore(String url) {
        return this.getDocId(url) != -1;
    }

    public final int getDocCount() {
        try {
            return (int)this.docIDsDB.count();
        }
        catch (DatabaseException e) {
            logger.error("Exception thrown while getting DOC Count", (Throwable)e);
            return -1;
        }
    }

    public void close() {
        try {
            this.docIDsDB.close();
        }
        catch (DatabaseException e) {
            logger.error("Exception thrown while closing DocIDServer", (Throwable)e);
        }
    }
}

